/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.util.Date;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.util.xml.XmlDataUtil;
import org.apache.log4j.Logger;

public class XmlImportTask
implements Runnable {
    private String filename;
    private boolean overwriteData = true;
    private static final Logger log = Logger.getLogger(XmlImportTask.class);

    public XmlImportTask(String filename, boolean overwriteData) {
        this.filename = filename;
        this.overwriteData = overwriteData;
    }

    @Override
    public void run() {
        MapFrame.getInstance().hidePanel();
        PleaseWaitDialog.getInstance(MapFrame.getInstance()).start(true);
        log.info("STARTED AT " + new Date());
        boolean result = false;
        try {
            XmlDataUtil.importDB(this.filename, this.overwriteData);
            result = true;
        }
        catch (Exception e) {
            log.error("Error while importing XML", e);
        }
        log.info("XML import finished at " + new Date());
        PleaseWaitDialog.getInstance().stop();
        MapFrame.getInstance().showPanel();
        MapFrame.getInstance().refreshAllObjects(false);
        MapFrame.getInstance().updateMap();
        MapFrame.getInstance().syncUIWithDataInDB();
        MapFrame.getInstance().getUIPanel().importDataActionFinish(result);
    }
}

