/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.util.Date;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.task.SelectionDialogTask;
import main.java.guru.vfrflight.util.xml.XmlDataUtil;
import org.apache.log4j.Logger;

public class XmlExportTask
extends SelectionDialogTask {
    private String filename;
    private boolean includeDeleteTags = true;
    private static final Logger log = Logger.getLogger(XmlExportTask.class);

    public XmlExportTask(String filename, boolean includeDeleteTags) {
        this.filename = filename;
        this.includeDeleteTags = includeDeleteTags;
    }

    public XmlExportTask(String filename, boolean includeDeleteTags, GpsArea area) {
        this.filename = filename;
        this.includeDeleteTags = includeDeleteTags;
        this.setArea(area);
    }

    @Override
    public void run() {
        MapFrame.getInstance().hidePanel();
        PleaseWaitDialog.getInstance(MapFrame.getInstance()).start(true);
        log.info("STARTED AT " + new Date());
        boolean result = false;
        try {
            XmlDataUtil.exportDB(this.filename, this.includeDeleteTags, this.getArea());
            result = true;
        }
        catch (Exception e) {
            log.error("Error while exporting XML", e);
        }
        log.info("XML export finished at " + new Date());
        PleaseWaitDialog.getInstance().stop();
        MapFrame.getInstance().showPanel();
        MapFrame.getInstance().getUIPanel().exportDataActionFinish(result);
    }
}

