/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.task.api.StoppableTask;
import main.java.guru.vfrflight.weather.WeatherUtil;
import main.java.guru.vfrflight.weather.core.Station;
import org.apache.log4j.Logger;

public class WeatherInRegionDownloadTask
extends StoppableTask
implements Runnable {
    private static final Logger log = Logger.getLogger(WeatherInRegionDownloadTask.class);
    private final boolean metar;
    private final boolean taf;
    private final boolean callFromUI;
    private GpsArea area;
    private List<Station> stations;

    public WeatherInRegionDownloadTask(boolean metar, boolean taf, boolean callFromUI) {
        this(null, metar, taf, callFromUI);
    }

    public WeatherInRegionDownloadTask(GpsArea area, boolean metar, boolean taf, boolean callFromUI) {
        this.area = area;
        this.metar = metar;
        this.taf = taf;
        this.callFromUI = callFromUI;
    }

    @Override
    public void run() {
        this.stations = new ArrayList<Station>();
        boolean success = true;
        int region = SettingsBean.getInstance().getParamMapRegionSelected();
        if (this.area == null) {
            if (region == 1) {
                this.area = SettingsBean.getInstance().getMapObjectsUserRegion();
            } else if (region != 0) {
                this.area = Constants.REGIONS[SettingsBean.getInstance().getParamMapRegionSelected()];
            }
        }
        if (this.area != null) {
            String key = this.area.getKey() + this.metar + this.taf;
            if (SettingsBean.getInstance().getWeatherCache().get(key) == null) {
                log.info("Downloading metars for region...");
                SettingsBean.getInstance().getWeatherCache().clear();
                SettingsBean.getInstance().getWeatherCache().put(key, WeatherUtil.getStationsInRegion(this.area, this.metar, this.taf));
            } else {
                log.info("Found metars in cache.");
            }
            this.stations = SettingsBean.getInstance().getWeatherCache().get(key);
        }
        if (this.isInterrupted() || !success) {
            this.stations = new ArrayList<Station>();
        }
        if (this.callFromUI) {
            if (this.isInterrupted() || !success) {
                MapFrame.getInstance().getUIPanel().updateWeatherStationsActionFinish(this.stations);
                if (!this.isInterrupted()) {
                    JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("weather_download_connection_error"), "", 0);
                }
            } else {
                MapFrame.getInstance().getUIPanel().updateWeatherStationsActionFinish(this.stations);
            }
        }
    }

    public List<Station> getStations() {
        return this.stations;
    }
}

