/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.gps.RouteSegment;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.task.api.StoppableTask;
import main.java.guru.vfrflight.weather.WeatherUtil;
import main.java.guru.vfrflight.weather.core.Station;

public class WeatherDownloadTask
extends StoppableTask
implements Runnable {
    private List<RouteSegment> segments;
    private boolean metar;
    private boolean taf;
    private int maxDistance;

    public WeatherDownloadTask(List<RouteSegment> segments, boolean metar, boolean taf, int maxDistance) {
        this.segments = new ArrayList<RouteSegment>(segments);
        this.metar = metar;
        this.taf = taf;
        this.maxDistance = maxDistance;
        PleaseWaitDialog.getInstance().setProgressMaximum(segments.size());
    }

    @Override
    public void run() {
        ArrayList<Station> stations = new ArrayList<Station>();
        ArrayList<String> stationsInList = new ArrayList<String>();
        boolean success = true;
        for (int q = 0; q < this.segments.size(); ++q) {
            LineSegment segment = this.segments.get(q);
            List<Station> loadedStations = WeatherUtil.getStationsOnPath(segment.getFrom(), segment.getTo(), this.maxDistance, this.metar, this.taf);
            if (!this.isInterrupted() && loadedStations != null) {
                for (Station s : loadedStations) {
                    if (this.isInterrupted() || stations.contains(s)) continue;
                    if (!stationsInList.contains(s.getIcao())) {
                        stationsInList.add(s.getIcao());
                        stations.add(s);
                        continue;
                    }
                    int idx = -1;
                    for (int i = 0; i < stations.size(); ++i) {
                        Station f = (Station)stations.get(i);
                        if (!f.getIcao().equals(s.getIcao())) continue;
                        idx = i;
                        break;
                    }
                    if (idx < 0) continue;
                    Station first = (Station)stations.get(idx);
                    if (first.getReport() != null && first.getReport().getTaf() == null) {
                        first.getReport().setTaf(s.getReport().getTaf());
                    }
                    if (first.getReport() != null && first.getReport().getMetar() == null) {
                        first.getReport().setMetar(s.getReport().getMetar());
                    }
                    stations.set(idx, first);
                }
            } else {
                success = false;
                break;
            }
            PleaseWaitDialog.getInstance().setProgress(q + 1);
        }
        if (this.isInterrupted() || !success) {
            MapFrame.getInstance().getUIPanel().updateWeatherStationsActionFinish(new ArrayList<Station>());
            if (!this.isInterrupted()) {
                JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("weather_download_connection_error"), "", 0);
            }
        } else {
            MapFrame.getInstance().getUIPanel().updateWeatherStationsActionFinish(stations);
        }
    }
}

