/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.JOptionPane;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.core.gps.RouteSegment;
import main.java.guru.vfrflight.gui.callable.WeatherDownloadCallable;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.task.api.StoppableTask;
import main.java.guru.vfrflight.weather.core.Station;
import org.apache.log4j.Logger;

public class WeatherDownloadMultiCoreTask
extends StoppableTask
implements Runnable {
    private static final Logger log = Logger.getLogger(WeatherDownloadMultiCoreTask.class);
    private List<RouteSegment> segments;
    private boolean metar;
    private boolean taf;
    private int maxDistance;

    public WeatherDownloadMultiCoreTask(List<RouteSegment> segments, boolean metar, boolean taf, int maxDistance) {
        this.segments = new ArrayList<RouteSegment>(segments);
        this.metar = metar;
        this.taf = taf;
        this.maxDistance = maxDistance;
        PleaseWaitDialog.getInstance().setProgressMaximum(segments.size());
    }

    @Override
    public void run() {
        int q;
        ArrayList<Station> stations = new ArrayList<Station>();
        List<String> stationsInList = Collections.synchronizedList(new ArrayList());
        ArrayList<Future<List<Station>>> stationsList = new ArrayList<Future<List<Station>>>();
        ExecutorService executor = Executors.newFixedThreadPool(Constants.NTHREDS_IO);
        boolean success = true;
        for (q = 0; q < this.segments.size(); ++q) {
            stationsList.add(executor.submit(new WeatherDownloadCallable(this.segments.get(q), this.metar, this.taf, this.maxDistance)));
        }
        q = 0;
        for (Future future : stationsList) {
            try {
                while (!this.isInterrupted() && !future.isDone()) {
                    Thread.yield();
                }
                if (this.isInterrupted()) {
                    future.cancel(true);
                } else {
                    List loadedStations = (List)future.get();
                    if (success && loadedStations != null) {
                        for (Station s : loadedStations) {
                            if (stations.contains(s)) continue;
                            if (!stationsInList.contains(s.getIcao())) {
                                stationsInList.add(s.getIcao());
                                stations.add(s);
                                continue;
                            }
                            int idx = -1;
                            for (int i = 0; i < stations.size(); ++i) {
                                Station f = (Station)stations.get(i);
                                if (!f.getIcao().equals(s.getIcao())) continue;
                                idx = i;
                                break;
                            }
                            if (idx < 0) continue;
                            Station first = (Station)stations.get(idx);
                            if (first.getReport() != null && first.getReport().getTaf() == null) {
                                first.getReport().setTaf(s.getReport().getTaf());
                            }
                            if (first.getReport() != null && first.getReport().getMetar() == null) {
                                first.getReport().setMetar(s.getReport().getMetar());
                            }
                            stations.set(idx, first);
                        }
                    } else {
                        success = false;
                    }
                }
                PleaseWaitDialog.getInstance().setProgress(q++);
            }
            catch (InterruptedException e) {
                log.debug(e, e);
                break;
            }
            catch (ExecutionException e) {
                log.error(e, e);
            }
        }
        executor.shutdown();
        log.debug("All finished.");
        if (this.isInterrupted() || !success) {
            MapFrame.getInstance().getUIPanel().updateWeatherStationsActionFinish(new ArrayList<Station>());
            if (!this.isInterrupted()) {
                JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("weather_download_connection_error"), "", 0);
            }
        } else {
            MapFrame.getInstance().getUIPanel().updateWeatherStationsActionFinish(stations);
        }
    }
}

