/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import main.java.guru.vfrflight.VfrMain;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.sql.SqlConnector;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import org.apache.log4j.Logger;

public class VfrShutdownTask
implements Runnable {
    private static final Logger log = Logger.getLogger(VfrShutdownTask.class);

    @Override
    public void run() {
        try {
            VfrUtil.supressGlobalExceptionHandler();
            log.info("Starting shutdown process");
            log.info("Saving params");
            SettingsBean.getInstance().saveParams();
            log.info("Stopping server through SqlConnector");
            SqlConnector.getInstance().shutdownServer(DBUtil.getDataSource().getSqlConnection());
            log.info("Stopping server");
            SqlConnector.getInstance().stopServer();
            log.info("Stopping external connection");
            if (SettingsBean.getInstance().isConnectedToSimAndHasData()) {
                SettingsBean.getInstance().getExtConnectTask().setRunning(false);
                SettingsBean.getInstance().setExtConnectTask(null);
            }
            log.info("Shutdown complete");
        }
        catch (Throwable e) {
            log.fatal(e, e);
        }
        finally {
            VfrMain.exit();
        }
    }
}

