/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.io.File;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.VfrMain;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.OpenAipInfoDialog;
import main.java.guru.vfrflight.gui.flightplan.SplashScreenDialog;
import main.java.guru.vfrflight.gui.flightplan.WelcomeScreenDialog;
import main.java.guru.vfrflight.gui.flightplan.YesNoQuestionDialog;
import main.java.guru.vfrflight.gui.task.CheckVersionTask;
import main.java.guru.vfrflight.gui.task.RefreshAllTask;
import main.java.guru.vfrflight.sql.facade.CityFacade;
import main.java.guru.vfrflight.sql.facade.ElevationFacade;
import main.java.guru.vfrflight.sql.facade.SqlFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import main.java.guru.vfrflight.util.xml.XmlDataUtil;

public class VfrInitTask
implements Runnable {
    @Override
    public void run() {
        CityFacade cityFacade;
        ElevationFacade elevationFacade;
        SqlFacade sqlFacade;
        File tmp = new File("tmp");
        if (!tmp.exists() || !tmp.isDirectory()) {
            tmp.mkdirs();
        }
        if (!(sqlFacade = new SqlFacade(DBUtil.getDataSource())).checkDBStructure()) {
            YesNoQuestionDialog dialogDefaultDatabase = new YesNoQuestionDialog(Messages.getInstance().get("data_files_import_dialog_header"));
            dialogDefaultDatabase.setVisible(true);
            if (dialogDefaultDatabase.isYesSelected()) {
                XmlDataUtil.importDB("data/", "data/db.zip", "data/db.xml");
                SettingsBean.getInstance().setAirportsTableSource("OPEN_AIP");
                SettingsBean.getInstance().setNavaidsTableSource("OPEN_AIP");
                SettingsBean.getInstance().setParamFsxP3dMode(false);
                OpenAipInfoDialog dialog = new OpenAipInfoDialog(null);
                dialog.setVisible(true);
            }
        }
        if ((elevationFacade = new ElevationFacade(DBUtil.getDataSource())).getElevationsNumber() == 0L) {
            elevationFacade.loadElevationsTableFromFile("data/", "data/elevations.zip", "data/elevations.dat");
        }
        if ((cityFacade = new CityFacade(DBUtil.getDataSource())).getCitiesNumber() == 0L) {
            cityFacade.loadCitiesTableFromFile("data/", "data/cities.zip", "data/cities.dat");
        }
        MapFrame.getInstance().getUIPanel().updateRecentLoadedFilesSubmenu();
        MapFrame.getInstance().showPanel();
        Thread t = new Thread(new CheckVersionTask());
        t.start();
        VfrUtil.setLayerVisibilityAction(new RefreshAllTask());
        MapFrame.getInstance().syncUIWithDataInDB();
        MapFrame.getInstance().setVisible(true);
        SplashScreenDialog.getInstance().setVisible(false);
        if (SettingsBean.getInstance().isParamShowWelcomeScreen()) {
            WelcomeScreenDialog welcome = new WelcomeScreenDialog(MapFrame.getInstance());
            welcome.setVisible(true);
        }
        VfrMain.initFinished();
    }
}

