/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.log4j.Logger;

public class SystemFileFtpUploaderTask
implements Runnable {
    private static final Logger log = Logger.getLogger(SystemFileFtpUploaderTask.class);
    private static final String FTP_SERVER = "serwer1411979.home.pl";
    private static final int FTP_PORT = 21;
    private static final String FTP_USER = "serwer1411979";
    private static final String FTP_PASS = "rQrDzNqDkobXPJRpwfNc";
    private final String localFilename;
    private final String remotePath;
    private final boolean deleteOnUpload;

    public SystemFileFtpUploaderTask(String localFilename, String remotePath, boolean deleteOnUpload) {
        this.localFilename = localFilename;
        this.remotePath = remotePath;
        this.deleteOnUpload = deleteOnUpload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean success = false;
        int tries = 3;
        do {
            block18: {
                try {
                    log.info("Uploading file " + this.localFilename + " to " + this.remotePath);
                    FTPClient ftpClient = new FTPClient();
                    FileInputStream inputStream = null;
                    try {
                        ftpClient.connect(FTP_SERVER, 21);
                        ftpClient.login(FTP_USER, FTP_PASS);
                        ftpClient.enterLocalPassiveMode();
                        ftpClient.setFileType(2);
                        inputStream = new FileInputStream(new File(this.localFilename));
                        boolean result = ftpClient.storeFile(this.remotePath, (InputStream)inputStream);
                        log.info("File upload " + this.localFilename + " to " + this.remotePath + " => " + result);
                        if (this.deleteOnUpload) {
                            IOUtil.deleteQuietly(this.localFilename);
                        }
                        IOUtil.closeQuietly(inputStream);
                    }
                    catch (IOException e) {
                        log.error("Error:", e);
                        break block18;
                    }
                    try {
                        if (ftpClient.isConnected()) {
                            ftpClient.logout();
                            ftpClient.disconnect();
                        }
                        break block18;
                    }
                    catch (IOException ex) {
                        log.error("Error:", ex);
                    }
                    break block18;
                    finally {
                        IOUtil.closeQuietly(inputStream);
                        try {
                            if (ftpClient.isConnected()) {
                                ftpClient.logout();
                                ftpClient.disconnect();
                            }
                        }
                        catch (IOException ex) {
                            log.error("Error:", ex);
                        }
                    }
                }
                catch (Exception e) {
                    log.error(e, e);
                }
            }
            if (!success && --tries >= 0) {
                VfrUtil.waitMilis(10000L);
            }
            if (success) return;
        } while (tries >= 0);
    }
}

