/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.UserTrackAnalyzerDialog;
import main.java.guru.vfrflight.util.SimConnectUtil;

public class ReplayUserTrackThread
extends Thread {
    private UserTrackAnalyzerDialog analyzerDialog;
    private boolean running = true;
    private float speed = 1.0f;

    public ReplayUserTrackThread(UserTrackAnalyzerDialog analyzerDialog, float speed) {
        this.analyzerDialog = analyzerDialog;
        this.speed = speed;
    }

    @Override
    public void run() {
        SimConnectUtil.getInstance().setSelectedUserTrackPoint(this.analyzerDialog.getAnalyzerPanel().getCurrentIndex());
        long firstTimestamp = this.analyzerDialog.getAnalyzerPanel().getCurrentUserBean().getTimestamp();
        long beginTimestamp = System.currentTimeMillis();
        do {
            if (!((float)(System.currentTimeMillis() - beginTimestamp) >= (float)(this.analyzerDialog.getAnalyzerPanel().getCurrentUserBean().getTimestamp() - firstTimestamp) / this.speed)) continue;
            this.analyzerDialog.getSlider().setValue(this.analyzerDialog.getSlider().getValue() + 1);
        } while (this.running && this.analyzerDialog.getAnalyzerPanel().getCurrentIndex() < this.analyzerDialog.getAnalyzerPanel().getUserTrack().size() - 1);
        SimConnectUtil.getInstance().setSelectedUserTrackPoint(null);
        this.analyzerDialog.getAnalyzerPanel().repaint();
        MapFrame.getInstance().updateMap();
        this.analyzerDialog.stopAction();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }
}

