/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.util.concurrent.Callable;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.TerrainElevationDTO;
import main.java.guru.vfrflight.util.ElevationsUtil;
import main.java.guru.vfrflight.util.VfrUtil;

public class RefreshTerrainElevationsTask
implements Callable<Integer> {
    @Override
    public Integer call() throws Exception {
        MapObjectsBean.getInstance().setTerrainElevations(null);
        if (SettingsBean.getInstance().isDrawTerrainElevations()) {
            TerrainElevationDTO[] elevList = ElevationsUtil.loadTerrainElevations(SettingsBean.getInstance().getParamMapRegionSelectedArea());
            if (elevList != null) {
                short min = Short.MAX_VALUE;
                short max = Short.MIN_VALUE;
                for (TerrainElevationDTO el : elevList) {
                    if (el.getElev() > max) {
                        max = el.getElev();
                    }
                    if (el.getElev() >= min) continue;
                    min = el.getElev();
                }
                for (TerrainElevationDTO el : elevList) {
                    el.setColor(VfrUtil.getColor(el.getElev(), min, max, 0.75f));
                }
            }
            MapObjectsBean.getInstance().setTerrainElevations(elevList);
        }
        return 0;
    }
}

