/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.RunwayExtensionDTO;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.core.sql.entity.Runway;
import main.java.guru.vfrflight.sql.facade.MapFacade;
import main.java.guru.vfrflight.util.DBUtil;

public class RefreshRunwaysExtensionsTask
implements Callable<Integer> {
    @Override
    public Integer call() throws Exception {
        MapFacade mapFacade;
        List<Airport> airports;
        MapObjectsBean.getInstance().setRunwayExtensions(null);
        if (SettingsBean.getInstance().isDrawRunwayExtensions() && (airports = (mapFacade = new MapFacade(DBUtil.getDataSource())).findAirports(SettingsBean.getInstance().getParamMapRegionSelected(), true)) != null && airports.size() > 0) {
            LinkedList<RunwayExtensionDTO> extList = new LinkedList<RunwayExtensionDTO>();
            for (Airport a : airports) {
                for (Runway r : a.getRunways()) {
                    if (r.getTrueHeading() == null) continue;
                    extList.add(new RunwayExtensionDTO(r, a.getIdent() + " " + r.getSecondaryName(), r.getElev(), true, a));
                    extList.add(new RunwayExtensionDTO(r, a.getIdent() + " " + r.getPrimaryName(), r.getElev(), false, a));
                }
            }
            if (extList.size() > 0) {
                MapObjectsBean.getInstance().setRunwayExtensions(extList.toArray(new RunwayExtensionDTO[extList.size()]));
            }
        }
        return 0;
    }
}

