/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.RadialFromVorDTO;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.MapUtil;
import main.java.org.jdesktop.swingx.mapviewer.GeoPosition;

public class RefreshRadialsFromVorsTask
implements Callable<Integer> {
    private final double rangeNm;

    public RefreshRadialsFromVorsTask(double rangeNm) {
        this.rangeNm = rangeNm;
    }

    @Override
    public Integer call() throws Exception {
        List<GpsPlace> vors;
        MapObjectsBean.getInstance().setRadialsFromVors(null);
        MapObjectsBean.getInstance().setRadialsFromVorsIntersections(null);
        if (SettingsBean.getInstance().isDrawRadialsFromVors() && (vors = FlightPlanBean.getInstance().getRoute().getOnlyVors()).size() > 0) {
            ArrayList<RadialFromVorDTO> radials = new ArrayList<RadialFromVorDTO>();
            for (GpsPlace vor : vors) {
                radials.addAll(this.createRadialsFromVor(vor, this.rangeNm, 1));
            }
            LinkedList<GpsPlace> intersections = new LinkedList<GpsPlace>();
            for (RadialFromVorDTO r1 : radials) {
                LineSegment l1 = r1.getLineSegment();
                for (RadialFromVorDTO r2 : radials) {
                    GpsPlace intersection;
                    if (r1.getUniqueId().equals(r2.getUniqueId()) || (intersection = MapUtil.getLineSegmentsIntersection(MapFrame.getInstance().getMapViewer(), l1, r2.getLineSegment())) == null) continue;
                    intersection.setName(r1.getUniqueId() + ";" + r2.getUniqueId());
                    intersections.add(intersection);
                }
            }
            MapObjectsBean.getInstance().setRadialsFromVorsIntersections(intersections.toArray(new GpsPlace[intersections.size()]));
            MapObjectsBean.getInstance().setRadialsFromVors(radials.toArray(new RadialFromVorDTO[radials.size()]));
        }
        return 0;
    }

    private List<RadialFromVorDTO> createRadialsFromVor(GpsPlace vor, double rangeNm, int stepDegrees) {
        ArrayList<RadialFromVorDTO> radials = new ArrayList<RadialFromVorDTO>();
        double magvar = vor.getMagvar() != null ? vor.getMagvar() : 0.0;
        GeoPosition from = vor.geoPosition();
        Random rand = new Random();
        Color color = new Color(rand.nextFloat() * 0.75f + 0.25f, rand.nextFloat() * 0.75f + 0.25f, rand.nextFloat() * 0.75f + 0.25f, 1.0f);
        String hash = vor.getLat().getValue() + vor.getLatHemisphere() + vor.getLon().getValue() + vor.getLonHemisphere();
        hash = hash.replaceAll("\\.", "");
        hash = hash.replaceAll(" ", "");
        for (int i = 0; i < 360; i += stepDegrees) {
            GeoPosition to = GpsUtil.getPointPositionByDistanceAndBearing(vor, (double)i + magvar, rangeNm).geoPosition();
            radials.add(new RadialFromVorDTO(hash, i, from, to, vor.getName() + " R" + FormatUtil.formattedCourse(Double.valueOf(i), false), i % 10 == 0, color));
        }
        return radials;
    }
}

