/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.ObstacleDTO;
import main.java.guru.vfrflight.core.sql.entity.Obstacle;
import main.java.guru.vfrflight.sql.facade.MapFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.UnitUtil;

public class RefreshObstaclesTask
implements Callable<Integer> {
    @Override
    public Integer call() throws Exception {
        MapFacade mapFacade;
        List<Obstacle> obstacles;
        MapObjectsBean.getInstance().setObstacles(null);
        if (SettingsBean.getInstance().isDrawObstacles() && (obstacles = (mapFacade = new MapFacade(DBUtil.getDataSource())).findObstacles(SettingsBean.getInstance().getParamMapRegionSelected())) != null && obstacles.size() > 0) {
            HashSet<ObstacleDTO> obstaclesList = new HashSet<ObstacleDTO>();
            for (Obstacle o : obstacles) {
                ObstacleDTO obs = new ObstacleDTO(o);
                if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                    if (obs.getAgl() != null) {
                        obs.setAgl((int)Math.round(UnitUtil.recalculateAltitude(obs.getAgl().intValue(), "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false)));
                    }
                    if (obs.getAmsl() != null) {
                        obs.setAmsl((int)Math.round(UnitUtil.recalculateAltitude(obs.getAmsl().intValue(), "ft", SettingsBean.getInstance().getParamUnitsAltitude(), false)));
                    }
                }
                obstaclesList.add(obs);
            }
            MapObjectsBean.getInstance().setObstacles(obstaclesList);
        }
        return 0;
    }
}

