/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.AirspaceAreaDTO;
import main.java.guru.vfrflight.core.sql.entity.AirspaceArea;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.sql.facade.MapFacade;
import main.java.guru.vfrflight.util.DBUtil;

public class RefreshAirspacesTask
implements Callable<Integer> {
    @Override
    public Integer call() throws Exception {
        MapObjectsBean.getInstance().setAirspaces(null);
        if (SettingsBean.getInstance().isDrawAirspaces()) {
            MapFacade mapFacade = new MapFacade(DBUtil.getDataSource());
            List<AirspaceArea> airspaces = mapFacade.findAirspaces(SettingsBean.getInstance().getParamMapRegionSelected());
            if (airspaces != null && airspaces.size() > 0) {
                ArrayList<AirspaceAreaDTO> mapAirspaces = new ArrayList<AirspaceAreaDTO>(airspaces.size());
                for (AirspaceArea a : airspaces) {
                    AirspaceAreaDTO air = new AirspaceAreaDTO(a);
                    air.calculateRectangleOver(MapFrame.getInstance().getMapViewer());
                    mapAirspaces.add(air);
                }
                Collections.sort(mapAirspaces);
                MapObjectsBean.getInstance().setAirspacesRefreshRunning(true);
                MapObjectsBean.getInstance().setAirspaces(mapAirspaces.toArray(new AirspaceAreaDTO[mapAirspaces.size()]));
                MapObjectsBean.getInstance().setAirspacesRefreshRunning(false);
            }
            MapFrame.getInstance().getUIPanel().getAirspacesFilterCollapsablePanel().updateAirspacesTypes();
        }
        return 0;
    }
}

