/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import main.java.guru.vfrflight.ElevationArray;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.dto.AirportDTO;
import main.java.guru.vfrflight.core.dto.AirspaceAreaDTO;
import main.java.guru.vfrflight.core.gl.GlPointTransformer;
import main.java.guru.vfrflight.core.gl.GlTerrainData;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.TerrainLayerDialog;
import main.java.guru.vfrflight.gui.flightplan.opengl.OpenGlTerrainCanvas;
import main.java.guru.vfrflight.gui.flightplan.opengl.OpenGlViewerFrame;
import main.java.guru.vfrflight.gui.task.api.StoppableTask;
import main.java.guru.vfrflight.util.ElevationsUtil;
import main.java.guru.vfrflight.util.GlUtil;
import main.java.guru.vfrflight.util.SimConnectUtil;
import main.java.guru.vfrflight.util.StaticMapUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.UrlUtil;
import org.apache.log4j.Logger;

public class OpenGlTerrainTask
extends StoppableTask
implements Runnable {
    private static final Logger log = Logger.getLogger(OpenGlTerrainTask.class);
    private final GpsArea area;
    private final TerrainLayerDialog dialog;
    private static final int CANVAS_WIDTH = 1024;
    private static final int CANVAS_HEIGHT = 768;

    public OpenGlTerrainTask(TerrainLayerDialog dialog, GpsArea area) {
        this.dialog = dialog;
        this.area = area;
    }

    @Override
    public void run() {
        try {
            Short max = null;
            Short min = null;
            if (!this.dialog.getMinElevAutoCheckbox().isSelected()) {
                try {
                    min = Short.valueOf(this.dialog.getMinElevTextField().getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!this.dialog.getMaxElevAutoCheckbox().isSelected()) {
                try {
                    max = Short.valueOf(this.dialog.getMaxElevTextField().getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.checkInterruption();
            ElevationArray elevationArray = ElevationsUtil.createElevationArray(ElevationsUtil.loadElevationsFromHgtFiles(this.dialog.getHgtPathPanel().getChosenPath(), this.dialog.getScaleValue(), this.dialog.getUseMaximumValueRadio().isSelected(), this.area, false), this.area, this.dialog.getDrawWithZeroCheckbox().isSelected());
            this.checkInterruption();
            if (elevationArray != null && elevationArray.hasData()) {
                if (!"m".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                    if (min != null) {
                        min = (short)Math.round(UnitUtil.recalculateAltitude(min.shortValue(), SettingsBean.getInstance().getParamUnitsAltitude(), "m", false));
                    }
                    if (max != null) {
                        max = (short)Math.round(UnitUtil.recalculateAltitude(max.shortValue(), SettingsBean.getInstance().getParamUnitsAltitude(), "m", false));
                    }
                }
                GlTerrainData terrainData = new GlTerrainData();
                GlPointTransformer transformer = new GlPointTransformer(this.area);
                terrainData.setMesh(GlUtil.triangulate(transformer, elevationArray, min, max));
                elevationArray = null;
                System.gc();
                terrainData.setRoute(GlUtil.transformRoute(transformer, FlightPlanBean.getInstance().getRoute().getPoints()));
                this.checkInterruption();
                if (SettingsBean.getInstance().isDrawUserTrack() && SimConnectUtil.getInstance().getUserTrack().size() > 0) {
                    terrainData.setUserTrack(GlUtil.transformUserTrack(transformer, this.area, SimConnectUtil.getInstance().getUserTrack(), SimConnectUtil.getInstance().getGroundAltitudeOffset()));
                }
                this.checkInterruption();
                if (SettingsBean.getInstance().isDrawAirspaces() && MapObjectsBean.getInstance().getAirspaces() != null) {
                    ArrayList<AirspaceAreaDTO> airspaces = new ArrayList<AirspaceAreaDTO>();
                    for (AirspaceAreaDTO ar : MapObjectsBean.getInstance().getAirspaces()) {
                        if (!MapObjectsBean.getInstance().getAirspaceFilter().checkDisplayAirspaceArea(ar) || !ar.isInside(this.area)) continue;
                        airspaces.add(ar);
                    }
                    if (airspaces.size() > 0) {
                        terrainData.setAirspaces(GlUtil.transformAirspaces(transformer, airspaces));
                    }
                }
                this.checkInterruption();
                if (SettingsBean.getInstance().isDrawAllAirports()) {
                    ArrayList<AirportDTO> airports = new ArrayList<AirportDTO>();
                    if (SettingsBean.getInstance().isDrawAllAirports()) {
                        for (AirportDTO a : MapObjectsBean.getInstance().getAirports(this.area)) {
                            if (!MapObjectsBean.getInstance().getAirportFilter().checkDisplayAirport(a) || !a.isInside(this.area)) continue;
                            airports.add(a);
                        }
                    }
                    if (airports.size() > 0) {
                        terrainData.setAirports(GlUtil.transformAirports(transformer, airports));
                    }
                }
                this.checkInterruption();
                int zoom = MapFrame.getInstance().getMapViewer().getZoom() - 1;
                if (zoom < 1) {
                    zoom = 1;
                }
                BufferedImage img = StaticMapUtil.getStaticMap(MapFrame.getInstance().getMapViewer(), this.area, zoom, 0, true, false);
                this.checkInterruption();
                UrlUtil.saveImage(img, "tmp/tex.png");
                this.checkInterruption();
                OpenGlTerrainCanvas canvas = new OpenGlTerrainCanvas(terrainData);
                canvas.setPreferredSize(new Dimension(1024, 768));
                this.dialog.finishedOpenGlTerrainTask(new OpenGlViewerFrame(canvas));
                System.gc();
            } else {
                this.dialog.finishedOpenGlTerrainTask(null);
            }
        }
        catch (Exception e) {
            log.error(e, e);
            this.dialog.finishedOpenGlTerrainTask(null);
        }
    }
}

