/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.util.List;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.task.api.StoppableTask;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import org.hsqldb.lib.StringUtil;

public class MeteoDownloadTask
extends StoppableTask
implements Runnable {
    private int progress = 0;
    private List<GpsPlace> pointsEnRoute;

    public MeteoDownloadTask(boolean atWPs, boolean middleSements, Integer stepDistance) {
        this.pointsEnRoute = GpsUtil.getPointsEnRoute(FlightPlanBean.getInstance().getRoute().getLineSegments(), atWPs, middleSements, stepDistance != null ? Double.valueOf(stepDistance.intValue()) : null);
        PleaseWaitDialog.getInstance().setProgressMaximum(this.pointsEnRoute.size());
    }

    @Override
    public void run() {
        MapFrame.getInstance().hidePanel();
        PleaseWaitDialog.getInstance(MapFrame.getInstance()).start(false, this);
        FlightPlanBean.getInstance().getRoute().calculateSegments();
        FlightPlanBean.getInstance().getRoute().getMeteoReports().clear();
        boolean allSuccessful = true;
        for (GpsPlace point : this.pointsEnRoute) {
            GpsPlace p;
            double dist = point.getDataDouble("dist");
            if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
                dist = (int)Math.round(UnitUtil.recalculateDistance(dist, "nm", SettingsBean.getInstance().getParamUnitsDistance(), false));
            }
            if (StringUtil.isEmpty((p = point.clone()).getName())) {
                String name = (double)Math.round(dist * 10.0) / 10.0 + SettingsBean.getInstance().getParamUnitsDistance();
                p.setName(name);
            }
            boolean bl = allSuccessful = this.addMeteoReport(p, dist) && allSuccessful;
            if (!this.isInterrupted()) continue;
            break;
        }
        PleaseWaitDialog.getInstance().stop();
        MapFrame.getInstance().showPanel();
        if (!this.isInterrupted()) {
            MapFrame.getInstance().getUIPanel().getMeteoWeatherActionStop(allSuccessful);
        }
    }

    public boolean addMeteoReport(GpsPlace place, double distanceEnRoute) {
        ++this.progress;
        PleaseWaitDialog.getInstance().setProgress(this.progress);
        return FlightPlanBean.getInstance().getRoute().addMeteoReport(place, distanceEnRoute);
    }
}

