/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.bean.constants.Constants;
import main.java.guru.vfrflight.core.MeteoReport;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.callable.MeteoDownloadCallable;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.task.api.StoppableTask;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import org.apache.log4j.Logger;
import org.hsqldb.lib.StringUtil;

public class MeteoDownloadMultiCoreTask
extends StoppableTask
implements Runnable {
    private static final Logger log = Logger.getLogger(MeteoDownloadMultiCoreTask.class);
    private int progress = 0;
    private List<GpsPlace> pointsEnRoute;
    private final boolean atWPs;
    private final boolean middleSements;
    private final Integer stepDistance;

    public MeteoDownloadMultiCoreTask(boolean atWPs, boolean middleSements, Integer stepDistance) {
        this.atWPs = atWPs;
        this.middleSements = middleSements;
        this.stepDistance = stepDistance;
    }

    @Override
    public void run() {
        this.pointsEnRoute = GpsUtil.getPointsEnRoute(FlightPlanBean.getInstance().getRoute().getLineSegments(), this.atWPs, this.middleSements, this.stepDistance != null ? Double.valueOf(this.stepDistance.intValue()) : null);
        PleaseWaitDialog.getInstance().setProgressMaximum(this.pointsEnRoute.size());
        MapFrame.getInstance().hidePanel();
        PleaseWaitDialog.getInstance(MapFrame.getInstance()).start(false, this);
        FlightPlanBean.getInstance().getRoute().calculateSegments();
        FlightPlanBean.getInstance().getRoute().getMeteoReports().clear();
        boolean allSuccessful = true;
        ExecutorService executor = Executors.newFixedThreadPool(Constants.NTHREDS_IO);
        ArrayList<Future<MeteoReport>> reportsList = new ArrayList<Future<MeteoReport>>();
        for (GpsPlace point : this.pointsEnRoute) {
            GpsPlace p;
            double d = point.getDataDouble("dist");
            if (!"nm".equals(SettingsBean.getInstance().getParamUnitsDistance())) {
                d = (int)Math.round(UnitUtil.recalculateDistance(d, "nm", SettingsBean.getInstance().getParamUnitsDistance(), false));
            }
            if (StringUtil.isEmpty((p = point.clone()).getName())) {
                String name = (double)Math.round(d * 10.0) / 10.0 + SettingsBean.getInstance().getParamUnitsDistance();
                p.setName(name);
            }
            reportsList.add(executor.submit(new MeteoDownloadCallable(p, d)));
            if (!this.isInterrupted()) continue;
            break;
        }
        ArrayList<MeteoReport> resultList = new ArrayList<MeteoReport>();
        for (Future future : reportsList) {
            try {
                while (!this.isInterrupted() && !future.isDone()) {
                    Thread.yield();
                }
                if (this.isInterrupted()) {
                    future.cancel(true);
                    continue;
                }
                MeteoReport result = (MeteoReport)future.get();
                ++this.progress;
                PleaseWaitDialog.getInstance().setProgress(this.progress);
                if (result != null) {
                    resultList.add(result);
                    continue;
                }
                allSuccessful = result != null && allSuccessful;
            }
            catch (InterruptedException e) {
                log.debug(e, e);
                break;
            }
            catch (ExecutionException e) {
                log.error(e, e);
            }
        }
        executor.shutdown();
        FlightPlanBean.getInstance().getRoute().getMeteoReports().addAll(resultList);
        log.debug("All finished.");
        PleaseWaitDialog.getInstance().stop();
        MapFrame.getInstance().showPanel();
        if (!this.isInterrupted()) {
            MapFrame.getInstance().getUIPanel().getMeteoWeatherActionStop(allSuccessful);
        }
    }
}

