/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import main.java.guru.vfrflight.bean.FpsEntry;
import main.java.guru.vfrflight.bean.SimConnectBean;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.util.SimConnectUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import org.apache.log4j.Logger;

public class MergeFpsEntriesTask
implements Runnable {
    private static final Logger log = Logger.getLogger(MergeFpsEntriesTask.class);
    private final List<FpsEntry> fpsEntries;

    public MergeFpsEntriesTask(List<FpsEntry> fpsEntries) {
        this.fpsEntries = new ArrayList<FpsEntry>(fpsEntries);
    }

    @Override
    public void run() {
        log.debug("MergeFpsEntriesTask: START");
        MapFrame.getInstance().hidePanel();
        PleaseWaitDialog.getInstance().start(false);
        PleaseWaitDialog.getInstance().setProgressMaximum(SimConnectUtil.getInstance().getUserTrack().size() - 1);
        for (int i = 0; i < SimConnectUtil.getInstance().getUserTrack().size() - 1; ++i) {
            log.debug("mergeUserTrackWithFpsEntries: " + (SimConnectUtil.getInstance().getUserTrack().size() - 1 - i));
            long timeFrom = SimConnectUtil.getInstance().getUserTrack().get(i).getTimestamp();
            long timeTo = SimConnectUtil.getInstance().getUserTrack().get(i + 1).getTimestamp();
            LinkedList<Float> fpsInRange = new LinkedList<Float>();
            for (FpsEntry entry : this.fpsEntries) {
                if (entry.getFps() != null && entry.getTime() >= timeFrom && entry.getTime() <= timeTo) {
                    fpsInRange.add(entry.getFps());
                    continue;
                }
                if (entry.getTime() <= timeTo) continue;
                break;
            }
            ((SimConnectBean)SimConnectUtil.getInstance().getUserTrack().get(i)).setFps(VfrUtil.calculateMedian(fpsInRange));
            PleaseWaitDialog.getInstance().setProgress(i + 1);
        }
        SimConnectUtil.getInstance().getFpsEntries().clear();
        PleaseWaitDialog.getInstance().stop();
        MapFrame.getInstance().showPanel();
        log.debug("MergeFpsEntriesTask: FINISHED");
    }
}

