/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import javax.swing.JOptionPane;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.TerrainLayerDialog;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.task.api.StoppableTask;
import main.java.guru.vfrflight.util.ElevationsUtil;
import main.java.guru.vfrflight.util.UnitUtil;
import org.apache.log4j.Logger;

public class LoadTerrainLayerTask
extends StoppableTask
implements Runnable {
    private static final Logger log = Logger.getLogger(LoadTerrainLayerTask.class);
    private final GpsArea area;
    private final TerrainLayerDialog dialog;
    private final boolean openIn3DViewer;

    public LoadTerrainLayerTask(TerrainLayerDialog dialog, GpsArea area, boolean openIn3DViewer) {
        this.area = area;
        this.dialog = dialog;
        this.openIn3DViewer = openIn3DViewer;
    }

    @Override
    public void run() {
        block12: {
            this.dialog.setVisible(false);
            MapObjectsBean.getInstance().setTerrainMeshArea(this.area.clone());
            MapObjectsBean.getInstance().setTerrainMesh(null);
            try {
                System.gc();
                MapObjectsBean.getInstance().setTerrainMesh(ElevationsUtil.createTerrainMeshFromHgtFiles(this.dialog.getHgtPathPanel().getChosenPath(), this.dialog.getScaleValue(), this.dialog.getUseMaximumValueRadio().isSelected(), this.dialog.getDrawWithZeroCheckbox().isSelected(), this.area));
                this.checkInterruption();
                if (MapObjectsBean.getInstance().isTerrainMesh()) {
                    Short max = null;
                    Short min = null;
                    if (!this.dialog.getMinElevAutoCheckbox().isSelected()) {
                        try {
                            min = Short.valueOf(this.dialog.getMinElevTextField().getText());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (!this.dialog.getMaxElevAutoCheckbox().isSelected()) {
                        try {
                            max = Short.valueOf(this.dialog.getMaxElevTextField().getText());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (!"ft".equals(SettingsBean.getInstance().getParamUnitsAltitude())) {
                        if (min != null) {
                            min = (short)Math.round(UnitUtil.recalculateAltitude(min.shortValue(), SettingsBean.getInstance().getParamUnitsAltitude(), "ft", false));
                        }
                        if (max != null) {
                            max = (short)Math.round(UnitUtil.recalculateAltitude(max.shortValue(), SettingsBean.getInstance().getParamUnitsAltitude(), "ft", false));
                        }
                    }
                    this.checkInterruption();
                    MapObjectsBean.getInstance().calculateTerrainMesh(this.dialog.getOpacityValue(), min, max);
                    MapFrame.getInstance().updateMap();
                    this.dialog.finishedTerrainLoadingTask(this.openIn3DViewer);
                    break block12;
                }
                PleaseWaitDialog.getInstance().stop();
                this.dialog.setVisible(true);
                MapObjectsBean.getInstance().setTerrainMesh(null);
                JOptionPane.showMessageDialog(this.dialog, Messages.getInstance().get("terrain_layer_dialog_no_elevations_found"), "", 0);
            }
            catch (Exception e) {
                log.error(e, e);
                PleaseWaitDialog.getInstance().stop();
                this.dialog.setVisible(true);
                MapObjectsBean.getInstance().setTerrainMesh(null);
            }
        }
    }
}

