/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.util.List;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.userpoint.UserPointsDialog;
import main.java.guru.vfrflight.gui.flightplan.userpoint.UserPointsTagsDialog;
import main.java.guru.vfrflight.sql.facade.UserPointFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UserPointsUtil;

public class ImportUserPointsTask
implements Runnable {
    private final String filename;
    private final UserPointsDialog mainDialog;

    public ImportUserPointsTask(UserPointsDialog mainDialog, String filename) {
        this.mainDialog = mainDialog;
        this.filename = filename;
    }

    @Override
    public void run() {
        boolean success = false;
        List<UserPoint> importedUserpoints = UserPointsUtil.loadUserPoints(this.filename);
        if (importedUserpoints != null && importedUserpoints.size() > 0) {
            UserPointsTagsDialog dialog = new UserPointsTagsDialog(MapFrame.getInstance());
            dialog.setVisible(true);
            if (!StringUtil.isEmpty(dialog.getTags())) {
                for (UserPoint userPoint : importedUserpoints) {
                    userPoint.setTags(UserPointsUtil.parsedTags(dialog.getTags()));
                }
            }
            UserPointFacade userPointFacade = new UserPointFacade(DBUtil.getDataSource());
            userPointFacade.insertUserPoints(importedUserpoints);
            this.mainDialog.reloadTables();
            success = true;
        }
        this.mainDialog.importActionFinish(success);
    }
}

