/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.userpoint.UserPointsDialog;
import main.java.guru.vfrflight.gui.flightplan.userpoint.UserPointsTagsDialog;
import main.java.guru.vfrflight.sql.facade.UserPointFacade;
import main.java.guru.vfrflight.util.DBUtil;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;
import main.java.guru.vfrflight.util.StringUtil;
import main.java.guru.vfrflight.util.UserPointsUtil;
import main.java.guru.vfrflight.util.VfrUtil;
import org.apache.log4j.Logger;

public class ImportUserPointsFromCustomCsvTask
implements Runnable {
    private static final Logger log = Logger.getLogger(ImportUserPointsFromCustomCsvTask.class);
    private final String filename;
    private final UserPointsDialog mainDialog;
    private final Character csvSeparator;
    private final int latColNum;
    private final int lonColNum;
    private final int nameColNum;
    private final Integer tagsColNum;

    public ImportUserPointsFromCustomCsvTask(UserPointsDialog mainDialog, String filename, Character csvSeparator, int latColNum, int lonColNum, int nameColNum, Integer tagsColNum) {
        this.mainDialog = mainDialog;
        this.filename = filename;
        this.csvSeparator = csvSeparator;
        this.latColNum = latColNum;
        this.lonColNum = lonColNum;
        this.nameColNum = nameColNum;
        this.tagsColNum = tagsColNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<UserPoint> userPoints = new ArrayList<UserPoint>();
        ArrayList<String> errors = new ArrayList<String>();
        int maxSelColNum = Math.max(this.nameColNum, Math.max(this.latColNum, this.lonColNum));
        if (this.tagsColNum != null) {
            maxSelColNum = Math.max(maxSelColNum, this.tagsColNum);
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(this.filename));
            String line = null;
            boolean running = true;
            int rowNum = 0;
            while ((line = br.readLine()) != null && running) {
                ++rowNum;
                if (!running) continue;
                String[] split = StringUtil.splitCsvLine(this.csvSeparator.charValue(), line.replace("\"\"", ""));
                if (split.length < maxSelColNum) {
                    errors.add(Messages.getInstance().get("user_points_custom_csv_import_dialog_invalid_column_number", String.valueOf(rowNum), String.valueOf(maxSelColNum)));
                    running = false;
                    continue;
                }
                UserPoint point = new UserPoint();
                point.setName(split[this.nameColNum - 1]);
                if (this.tagsColNum != null) {
                    point.setTags(UserPointsUtil.parsedTags(split[this.tagsColNum - 1]));
                }
                String coordsTxt = null;
                coordsTxt = this.latColNum == this.lonColNum ? split[this.latColNum - 1] : split[this.latColNum - 1] + " " + split[this.lonColNum - 1];
                GpsPlace place = FormatUtil.stringToGpsPlace(coordsTxt);
                if (place == null) {
                    errors.add(Messages.getInstance().get("user_points_custom_csv_import_dialog_invalid_coordinates", String.valueOf(rowNum)));
                    continue;
                }
                point.setLat(place.getLatVal());
                point.setLon(place.getLonVal());
                userPoints.add(point);
            }
        }
        catch (IOException e) {
            try {
                log.error(e, e);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(br);
                throw throwable;
            }
            IOUtil.closeQuietly(br);
        }
        IOUtil.closeQuietly(br);
        boolean success = false;
        if (errors.size() > 0) {
            VfrUtil.showErrorsListDialog(this.mainDialog, errors);
        } else {
            UserPointsTagsDialog dialog = new UserPointsTagsDialog(MapFrame.getInstance());
            dialog.setVisible(true);
            if (!StringUtil.isEmpty(dialog.getTags())) {
                for (UserPoint userPoint : userPoints) {
                    String tags = "";
                    if (!StringUtil.isEmpty(userPoint.getTags())) {
                        tags = UserPointsUtil.getParsedTags(userPoint.getTags()) + ",";
                    }
                    userPoint.setTags(UserPointsUtil.parsedTags(tags + dialog.getTags()));
                }
            }
            UserPointFacade userPointFacade = new UserPointFacade(DBUtil.getDataSource());
            userPointFacade.insertUserPoints(userPoints);
            this.mainDialog.reloadTables();
            success = true;
        }
        this.mainDialog.importActionFinish(success);
    }
}

