/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import javax.swing.JOptionPane;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.gps.RotatedGpsArea;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.task.api.StoppableTask;
import main.java.guru.vfrflight.pdf.util.PdfUtil;

public class ExportMapPngTask
extends StoppableTask
implements Runnable {
    private final String fileName;
    private final RotatedGpsArea area;
    private final int zoom;
    private final boolean withCompassRose;
    private final int compassRoseLocation;
    private final Double magvar;

    public ExportMapPngTask(String fileName, RotatedGpsArea area, int zoom, boolean withCompassRose, Double magvar, int compassRoseLocation) {
        this.fileName = fileName;
        this.area = area;
        this.zoom = zoom;
        this.withCompassRose = withCompassRose;
        this.compassRoseLocation = compassRoseLocation;
        this.magvar = magvar;
    }

    @Override
    public void run() {
        MapFrame.getInstance().hidePanel();
        PleaseWaitDialog.getInstance(MapFrame.getInstance()).start();
        boolean result = PdfUtil.createMapInPng(this.fileName, this.area, this.zoom, this.withCompassRose, this.magvar, this.compassRoseLocation);
        PleaseWaitDialog.getInstance().stop();
        MapFrame.getInstance().showPanel();
        if (result) {
            JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("map_export_success"), "", 1);
        } else {
            JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("map_export_error"), "", 0);
        }
    }
}

