/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import javax.swing.JOptionPane;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.gps.RotatedGpsArea;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.task.api.StoppableTask;
import main.java.guru.vfrflight.pdf.util.PdfUtil;
import main.java.guru.vfrflight.util.IO.IOUtil;

public class ExportMapPdfTask
extends StoppableTask
implements Runnable {
    private final String fileName;
    private final RotatedGpsArea area;
    private final int zoom;
    private final boolean withCompassRose;
    private final int compassRoseLocation;
    private final Double magvar;

    public ExportMapPdfTask(String fileName, RotatedGpsArea area, int zoom, boolean withCompassRose, Double magvar, int compassRoseLocation) {
        this.fileName = fileName;
        this.area = area;
        this.zoom = zoom;
        this.withCompassRose = withCompassRose;
        this.compassRoseLocation = compassRoseLocation;
        this.magvar = magvar;
    }

    @Override
    public void run() {
        MapFrame.getInstance().hidePanel();
        PleaseWaitDialog.getInstance(MapFrame.getInstance()).start();
        boolean result = PdfUtil.createMapInPdf(this.fileName, this.area, this.zoom, this.withCompassRose, this.magvar, this.compassRoseLocation);
        PleaseWaitDialog.getInstance().stop();
        MapFrame.getInstance().showPanel();
        if (result) {
            if (JOptionPane.showConfirmDialog(MapFrame.getInstance(), Messages.getInstance().get("pdf_export_success"), "", 0) == 0) {
                IOUtil.openFileInDesktop(this.fileName);
            }
        } else {
            JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("pdf_export_error"), "", 0);
        }
        if (result) {
            JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("map_export_success"), "", 1);
        } else {
            JOptionPane.showMessageDialog(MapFrame.getInstance(), Messages.getInstance().get("map_export_error"), "", 0);
        }
    }
}

