/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.util.ArrayList;
import java.util.List;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.sql.TerrainMesh;
import main.java.guru.vfrflight.gui.flightplan.EngineLossRangeDialog;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.task.api.StoppableTask;
import main.java.guru.vfrflight.util.ElevationsUtil;
import main.java.guru.vfrflight.util.EngineLoss;
import org.apache.log4j.Logger;

public class EngineLossTask
extends StoppableTask
implements Runnable {
    private static final Logger log = Logger.getLogger(EngineLossTask.class);
    private final EngineLoss engineLoss;
    private final String hgtFilesPath;
    private final EngineLossRangeDialog mainDialog;
    private GpsPlace place;

    public EngineLossTask(EngineLossRangeDialog mainDialog, EngineLoss engineLoss, String hgtFilesPath) {
        this.mainDialog = mainDialog;
        this.engineLoss = engineLoss;
        this.hgtFilesPath = hgtFilesPath;
    }

    public GpsPlace getPlace() {
        return this.place;
    }

    public void setPlace(GpsPlace place) {
        this.place = place;
    }

    @Override
    public void run() {
        PleaseWaitDialog.getInstance().setProgressMaximum(this.engineLoss.getSamplesNum());
        MapFrame.getInstance().hidePanel();
        PleaseWaitDialog.getInstance().start(false, this);
        GpsArea maximumRangeArea = this.engineLoss.getMaximumRangeArea(this.place);
        GpsPlace topLeft = maximumRangeArea.getTopLeft();
        GpsPlace topRight = maximumRangeArea.getTopRight();
        GpsPlace bottomRight = maximumRangeArea.getBottomRight();
        GpsPlace bottomLeft = maximumRangeArea.getBottomLeft();
        GpsArea[] quaterArea = new GpsArea[]{new GpsArea(topLeft.getLatVal(), this.place.getLonVal(), this.place.getLatVal(), topRight.getLonVal()), new GpsArea(this.place.getLatVal(), this.place.getLonVal(), bottomRight.getLatVal(), bottomRight.getLonVal()), new GpsArea(this.place.getLatVal(), topLeft.getLonVal(), bottomLeft.getLatVal(), this.place.getLonVal()), new GpsArea(topLeft.getLatVal(), topLeft.getLonVal(), this.place.getLatVal(), this.place.getLonVal())};
        ArrayList<TerrainMesh[]> meshes = new ArrayList<TerrainMesh[]>(4);
        for (int i = 0; i < 4; ++i) {
            TerrainMesh[] mesh = ElevationsUtil.createTerrainMeshFromHgtFiles(this.hgtFilesPath, 1, false, true, quaterArea[i]);
            if (mesh.length <= 0) continue;
            meshes.add(mesh);
        }
        List<LineSegment> result = null;
        if (meshes.size() > 0) {
            result = SettingsBean.getInstance().isParamUseMultipleCores() ? this.engineLoss.calculateEngineLossRangeForPlaceMultiCore(MapFrame.getInstance().getMapViewer(), this.place, meshes, true) : this.engineLoss.calculateEngineLossRangeForPlace(MapFrame.getInstance().getMapViewer(), this.place, meshes, true);
        } else {
            log.error("Couldn't find any elevation samples");
        }
        PleaseWaitDialog.getInstance().stop();
        MapFrame.getInstance().showPanel();
        this.mainDialog.calculationsFinished(result);
    }
}

