/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.util.concurrent.locks.LockSupport;
import main.java.guru.vfrflight.core.gps.GpsArea;
import main.java.guru.vfrflight.gui.flightplan.DownloadMapToHddDialog;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitConsoleDialog;
import main.java.guru.vfrflight.gui.map.VfrMapViewer;
import main.java.guru.vfrflight.gui.task.api.StoppableTask;
import main.java.guru.vfrflight.util.downloader.MapBulkDownloader;

public class DownloadMapToHddTask
extends StoppableTask
implements Runnable {
    private final DownloadMapToHddDialog mainDialog;
    private final VfrMapViewer mapViewer;
    private final GpsArea area;
    private final String outputPath;
    private final int zoomFrom;
    private final int zoomTo;
    private boolean withRandomDelay;

    public DownloadMapToHddTask(DownloadMapToHddDialog mainDialog, VfrMapViewer mapViewer, GpsArea area, String outputPath, int zoomFrom, int zoomTo, boolean withRandomDelay) {
        this.mainDialog = mainDialog;
        this.mapViewer = mapViewer;
        this.area = area;
        this.outputPath = outputPath;
        this.zoomFrom = zoomFrom;
        this.zoomTo = zoomTo;
        this.withRandomDelay = withRandomDelay;
    }

    @Override
    public void run() {
        MapFrame.getInstance().hidePanel();
        PleaseWaitConsoleDialog.getInstance().start(this);
        MapBulkDownloader mapDownloader = new MapBulkDownloader(this, this.mapViewer, this.outputPath, this.withRandomDelay, PleaseWaitConsoleDialog.getInstance());
        mapDownloader.execute(this.area, this.zoomFrom, this.zoomTo);
        while (mapDownloader.isRunning() && !this.isInterrupted()) {
            LockSupport.parkNanos(250000000L);
        }
        mapDownloader.setRunning(false);
        PleaseWaitConsoleDialog.getInstance().stop();
        MapFrame.getInstance().showPanel();
        this.mainDialog.downloadFinishedAction(this.isInterrupted());
    }
}

