/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.util.ArrayList;
import java.util.List;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.MapObjectsBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.core.sql.entity.Elevation;
import main.java.guru.vfrflight.gui.flightplan.VerticalProfileMainDialog;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.gui.task.api.StoppableTask;
import main.java.guru.vfrflight.util.GpsUtil;
import main.java.guru.vfrflight.util.VfrUtil;

public class CalculateVerticalProfileTask
extends StoppableTask
implements Runnable {
    private VerticalProfileMainDialog dialog;
    private int samplesNum;

    public CalculateVerticalProfileTask(VerticalProfileMainDialog dialog, int samplesNum) {
        this.dialog = dialog;
        this.samplesNum = samplesNum;
    }

    @Override
    public void run() {
        this.dialog.setVisible(false);
        int width = SettingsBean.getInstance().getVerticalProfileBean().getSamplesNum();
        int height = SettingsBean.getInstance().getVerticalProfileBean().getHeight();
        boolean findMaxValue = SettingsBean.getInstance().getVerticalProfileBean().isFindMaxValue();
        double gridSize = (double)this.samplesNum / (double)width * 0.09 * (double)((this.dialog.getScaleValue() - 1) / 2 + 1);
        Elevation[] elev = null;
        if (!this.dialog.getWithTerrainCheckBox().isSelected()) {
            List<GpsPlace> pointsEnRoute = GpsUtil.getPointsEnRoute(new ArrayList<LineSegment>(FlightPlanBean.getInstance().getRoute().getSegments()), width);
            elev = new Elevation[width >= pointsEnRoute.size() ? width : pointsEnRoute.size()];
            for (int i = 0; i < pointsEnRoute.size(); ++i) {
                elev[i] = new Elevation();
                elev[i].setElev((short)0);
                elev[i].setLat(pointsEnRoute.get(i).getLat().getValue());
                elev[i].setLon(pointsEnRoute.get(i).getLon().getValue());
            }
        }
        if (this.dialog.getWithTerrainCheckBox().isSelected() && !this.isInterrupted()) {
            elev = SettingsBean.getInstance().isParamUseMultipleCores() ? VfrUtil.calculateVerticalProfileMultiCore(this, FlightPlanBean.getInstance().getRoute().getSegments(), gridSize, width, this.dialog.getHgtPathPanel().getChosenPath(), this.dialog.getScaleValue(), findMaxValue) : VfrUtil.calculateVerticalProfile(this, FlightPlanBean.getInstance().getRoute().getSegments(), gridSize, width, this.dialog.getHgtPathPanel().getChosenPath(), this.dialog.getScaleValue(), findMaxValue);
        }
        if (!this.dialog.getWithTerrainCheckBox().isSelected() || !this.isInterrupted() && elev != null && elev.length > 0) {
            this.dialog.finishedTerrainLoadingTask(elev, height);
        } else {
            PleaseWaitDialog.getInstance().stop();
            this.dialog.setVisible(true);
            MapObjectsBean.getInstance().setTerrainMesh(null);
            if (!this.isInterrupted()) {
                this.dialog.noElevationsFoundError();
            }
        }
    }
}

