/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.task;

import java.util.Date;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.flightplan.wait.PleaseWaitDialog;
import main.java.guru.vfrflight.util.aixm.AixmAirportsUtil;
import main.java.guru.vfrflight.util.aixm.AixmAirspacesUtil;
import main.java.guru.vfrflight.util.aixm.AixmNavaidsUtil;
import main.java.guru.vfrflight.util.aixm.AixmObstaclesUtil;
import main.java.guru.vfrflight.util.aixm.AixmPointsUtil;
import org.apache.log4j.Logger;

public class AixmImportTask
implements Runnable {
    private String filename;
    private boolean overwriteData = true;
    private static final Logger log = Logger.getLogger(AixmImportTask.class);

    public AixmImportTask(String filename, boolean overwriteData) {
        this.filename = filename;
        this.overwriteData = overwriteData;
    }

    @Override
    public void run() {
        MapFrame.getInstance().hidePanel();
        PleaseWaitDialog.getInstance(MapFrame.getInstance()).start(true);
        log.info("STARTED AT " + new Date());
        boolean result = false;
        try {
            AixmAirspacesUtil.importAirspaces(this.filename, this.overwriteData);
            AixmAirportsUtil.importAirports(this.filename, this.overwriteData);
            AixmNavaidsUtil.importNavaids(this.filename, this.overwriteData);
            AixmPointsUtil.importVfrIfrPoints(this.filename, this.overwriteData, this.overwriteData);
            AixmObstaclesUtil.importObstacles(this.filename, this.overwriteData);
            SettingsBean.getInstance().setAirportsTableSource("AIXM");
            SettingsBean.getInstance().setNavaidsTableSource("AIXM");
            result = true;
        }
        catch (Exception e) {
            log.error("Error while importing AIXM", e);
        }
        log.info("AIXM import finished at " + new Date());
        PleaseWaitDialog.getInstance().stop();
        MapFrame.getInstance().showPanel();
        MapFrame.getInstance().refreshAllObjects(false);
        MapFrame.getInstance().updateMap();
        MapFrame.getInstance().syncUIWithDataInDB();
        MapFrame.getInstance().getUIPanel().importDataActionFinish(result);
    }
}

