/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table.model;

import java.util.ArrayList;
import java.util.List;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.gui.table.model.DataTableModel;
import main.java.guru.vfrflight.gui.table.model.row.WnBRow;

public class WeightAndBalanceTableModel
extends DataTableModel {
    private static final long serialVersionUID = 3142587258560417772L;
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_QUANTITY = 1;
    public static final int COLUMN_QUANTITY_UNIT = 2;
    public static final int COLUMN_ARM = 3;
    public static final int COLUMN_TORQUE = 4;
    private static final Class[] columnTypes = new Class[]{String.class, Double.class, String.class, Double.class, Double.class};
    private final String[] columnNames = new String[]{Messages.getInstance().get("wnb_table_name"), Messages.getInstance().get("wnb_table_quantity"), "", Messages.getInstance().get("wnb_table_arm"), Messages.getInstance().get("wnb_table_torque")};

    public Class getColumnClass(int columnIndex) {
        return columnTypes[columnIndex];
    }

    public WeightAndBalanceTableModel() {
        super((Object[][])new Object[0][], new String[0]);
        this.setColumnIdentifiers(this.columnNames);
    }

    public void addWnbRow(WnBRow row) {
        Object[] r = new Object[]{row.getName(), row.getQuantity(), row.getQuantityUnit(), row.getArm(), row.getTorque()};
        this.addRow(r);
    }

    public WnBRow getWnbRowAt(int row) {
        String name = null;
        if (this.getValueAt(row, 0) != null) {
            name = this.getValueAt(row, 0).toString();
        }
        Double quantity = null;
        if (this.getValueAt(row, 1) != null) {
            quantity = Double.valueOf(this.getValueAt(row, 1).toString());
        }
        String quantityUnit = null;
        if (this.getValueAt(row, 2) != null) {
            quantityUnit = this.getValueAt(row, 2).toString();
        }
        Double arm = null;
        if (this.getValueAt(row, 3) != null) {
            arm = Double.valueOf(this.getValueAt(row, 3).toString());
        }
        Double torque = null;
        if (this.getValueAt(row, 4) != null) {
            torque = Double.valueOf(this.getValueAt(row, 4).toString());
        }
        return new WnBRow(name, quantity, quantityUnit, arm, torque);
    }

    public List<WnBRow> getData() {
        ArrayList<WnBRow> data = new ArrayList<WnBRow>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            data.add(this.getWnbRowAt(i));
        }
        return data;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column != 4;
    }
}

