/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table.model;

import java.util.ArrayList;
import java.util.List;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.gui.table.waypoints.WaypointsTableModel;
import main.java.guru.vfrflight.util.FormatUtil;
import main.java.guru.vfrflight.util.StringUtil;

public class VorTableModel
extends WaypointsTableModel {
    private static final long serialVersionUID = -4855547890601577382L;
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_LAT_DEG = 1;
    public static final int COLUMN_LAT_MIN = 2;
    public static final int COLUMN_LAT_SEC = 3;
    public static final int COLUMN_LAT_HEMISPH = 4;
    public static final int COLUMN_LON_DEG = 5;
    public static final int COLUMN_LON_MIN = 6;
    public static final int COLUMN_LON_SEC = 7;
    public static final int COLUMN_LON_HEMISPH = 8;
    public static final int COLUMN_ALT = 9;
    public static final int COLUMN_FREQ = 10;
    public static final int COLUMN_MAGVAR = 11;
    public static final int COLUMN_TYPE = 12;
    private static final Class[] columnTypes = new Class[]{String.class, Integer.class, Integer.class, Double.class, String.class, Integer.class, Integer.class, Double.class, String.class, Double.class, Double.class, Double.class, String.class};
    private final String[] columnNames = new String[]{Messages.getInstance().get("table_name"), Messages.getInstance().get("table_lat_deg"), Messages.getInstance().get("table_lat_min"), Messages.getInstance().get("table_lat_sec"), "", Messages.getInstance().get("table_lon_deg"), Messages.getInstance().get("table_lon_min"), Messages.getInstance().get("table_lon_sec"), "", Messages.getInstance().get("table_alt", SettingsBean.getInstance().getParamUnitsAltitude()), Messages.getInstance().get("table_freq"), Messages.getInstance().get("table_magvar"), ""};

    public Class getColumnClass(int columnIndex) {
        return columnTypes[columnIndex];
    }

    public VorTableModel() {
        super((Object[][])new Object[0][], new String[0]);
        this.setColumnIdentifiers(this.columnNames);
    }

    @Override
    public void addPoint(RoutePlace point, Integer index) {
        Object[] row = new Object[]{point.getName(), point.getLat().getDeg(), point.getLat().getMin(), point.getLat().getSec(), point.getLatHemisphere(), point.getLon().getDeg(), point.getLon().getMin(), point.getLon().getSec(), point.getLonHemisphere(), point.getAlt(), this.formatVorNdbFrequency(point), point.getDataDouble("magvar") != null ? point.getDataDouble("magvar") : null, point.getType()};
        if (index == null) {
            this.addRow(row);
        } else {
            this.insertRow((int)index, row);
        }
    }

    private Double formatVorNdbFrequency(GpsPlace navaid) {
        Integer freq = navaid.getDataInt("freq");
        if (freq == null) {
            return null;
        }
        return navaid.isNdb() ? Double.valueOf(FormatUtil.formatNdbFrequency(freq)) : Double.valueOf(FormatUtil.formatVorFrequency(freq));
    }

    @Override
    protected boolean rowHasCompleteData(int row) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (i == 9 || i == 10 || i == 11 || this.getValueAt(row, i) != null && (!(this.getValueAt(row, i) instanceof String) || !StringUtil.isEmpty((String)this.getValueAt(row, i)))) continue;
            return false;
        }
        return true;
    }

    public RoutePlace getPointAtRow(int row) {
        if (this.rowHasCompleteData(row)) {
            int latDeg = Integer.valueOf(this.getValueAt(row, 1).toString());
            int latMin = Integer.valueOf(this.getValueAt(row, 2).toString());
            double latSec = Double.valueOf(this.getValueAt(row, 3).toString());
            int lonDeg = Integer.valueOf(this.getValueAt(row, 5).toString());
            int lonMin = Integer.valueOf(this.getValueAt(row, 6).toString());
            double lonSec = Double.valueOf(this.getValueAt(row, 7).toString());
            String name = this.getValueAt(row, 0).toString();
            Double alt = null;
            if (this.getValueAt(row, 9) != null && !StringUtil.isEmpty(this.getValueAt(row, 9).toString())) {
                alt = (double)Double.valueOf(this.getValueAt(row, 9).toString());
            }
            Double freq = null;
            if (this.getValueAt(row, 10) != null && !StringUtil.isEmpty(this.getValueAt(row, 10).toString())) {
                freq = (double)Double.valueOf(this.getValueAt(row, 10).toString());
            }
            Double magvar = null;
            if (this.getValueAt(row, 11) != null && !StringUtil.isEmpty(this.getValueAt(row, 11).toString())) {
                magvar = (double)Double.valueOf(this.getValueAt(row, 11).toString());
            }
            String type = "VOR";
            if (this.getValueAt(row, 12) != null) {
                type = (String)this.getValueAt(row, 12);
            }
            RoutePlace point = new RoutePlace(new GpsCoord(latDeg, latMin, latSec), new GpsCoord(lonDeg, lonMin, lonSec), name, alt);
            point.setType(type);
            point.setLatHemisphere(this.getValueAt(row, 4).toString());
            point.setLonHemisphere(this.getValueAt(row, 8).toString());
            if (freq != null) {
                if (point.isNdb()) {
                    point.setDataInt("freq", (int)Math.round(freq * 10.0));
                } else {
                    point.setDataInt("freq", (int)Math.round(freq * 1000.0));
                }
            }
            if (magvar != null) {
                point.setDataDouble("magvar", magvar);
            }
            point.setType(type);
            return point;
        }
        return null;
    }

    @Override
    public List<RoutePlace> getData() {
        ArrayList<RoutePlace> data = new ArrayList<RoutePlace>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            RoutePlace place = this.getPointAtRow(row);
            if (place == null) continue;
            data.add(place);
        }
        return data;
    }

    @Override
    public void addPoint(RoutePlace point) {
        this.addPoint(point, null);
    }
}

