/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table.model;

import java.util.List;
import java.util.Map;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.Route;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.LineSegment;
import main.java.guru.vfrflight.gui.table.model.DataTableModel;
import main.java.guru.vfrflight.util.FormatUtil;

public class VorResultTableModel
extends DataTableModel {
    private static final long serialVersionUID = 5706965270327187265L;
    private static Class[] columnTypes;
    private static String[] columnNames;

    public Class getColumnClass(int columnIndex) {
        return columnTypes[columnIndex];
    }

    public VorResultTableModel(Route route) {
        List<GpsPlace> vorsList = route.getOnlyVors();
        columnTypes = new Class[vorsList.size() + 1];
        columnNames = new String[vorsList.size() + 1];
        VorResultTableModel.columnTypes[0] = String.class;
        VorResultTableModel.columnNames[0] = Messages.getInstance().get("table_point");
        this.addColumn(columnNames[0]);
        int q = 1;
        for (GpsPlace vor : vorsList) {
            VorResultTableModel.columnTypes[q] = String.class;
            VorResultTableModel.columnNames[q] = vor.getName();
            this.addColumn(columnNames[q]);
            ++q;
        }
        for (q = 0; q < route.getPoints().size(); ++q) {
            GpsPlace point = route.getPoints().get(q);
            Object[] row = new Object[vorsList.size() + 1];
            row[0] = point.getName();
            Map<String, LineSegment> radials = route.getVorRadials(point);
            for (int i = 1; i < vorsList.size() + 1; ++i) {
                LineSegment radial = radials.get(vorsList.get(i - 1).getName());
                row[i] = FormatUtil.formatRadial(radial);
            }
            this.addRow(row);
        }
    }

    public VorResultTableModel() {
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }
}

