/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table.model;

import java.util.ArrayList;
import java.util.List;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.dto.VfrPointDTO;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.table.model.DataTableModel;

public class VfrPointsValTableModel
extends DataTableModel {
    private static final long serialVersionUID = -924022288551764480L;
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_LAT = 1;
    public static final int COLUMN_LAT_HEMISPH = 2;
    public static final int COLUMN_LON = 3;
    public static final int COLUMN_LON_HEMISPH = 4;
    private static final Class[] columnTypes = new Class[]{String.class, Double.class, String.class, Double.class, String.class};
    private final String[] columnNames = new String[]{Messages.getInstance().get("table_name"), Messages.getInstance().get("table_lat"), "", Messages.getInstance().get("table_lon"), ""};

    public Class getColumnClass(int columnIndex) {
        return columnTypes[columnIndex];
    }

    public VfrPointsValTableModel() {
        super((Object[][])new Object[0][], new String[0]);
        this.setColumnIdentifiers(this.columnNames);
    }

    public void addPoint(VfrPointDTO p) {
        GpsPlace point = p.getGpsPlace();
        Object[] row = new Object[]{p.getName(), Math.abs(point.getLat().getValue()), point.getLatHemisphere(), Math.abs(point.getLon().getValue()), point.getLonHemisphere()};
        this.addRow(row);
    }

    public VfrPointDTO getPointAtRow(int row) {
        if (this.rowHasCompleteData(row)) {
            double lat = Double.valueOf(this.getValueAt(row, 1).toString());
            double lon = Double.valueOf(this.getValueAt(row, 3).toString());
            GpsPlace point = new GpsPlace(lat, lon);
            point.setLatHemisphere(this.getValueAt(row, 2).toString());
            point.setLonHemisphere(this.getValueAt(row, 4).toString());
            point.setName(this.getValueAt(row, 0).toString());
            return new VfrPointDTO(point);
        }
        return null;
    }

    public List<VfrPointDTO> getData() {
        ArrayList<VfrPointDTO> data = new ArrayList<VfrPointDTO>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            VfrPointDTO point = this.getPointAtRow(row);
            if (point == null) continue;
            data.add(point);
        }
        return data;
    }

    public boolean allRowsComplete() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (this.rowHasCompleteData(row)) continue;
            return false;
        }
        return true;
    }
}

