/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table.model;

import java.util.ArrayList;
import java.util.List;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.dto.VfrPointDTO;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.table.model.DataTableModel;

public class VfrPointsTableModel
extends DataTableModel {
    private static final long serialVersionUID = 1323087513289281235L;
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_LAT_DEG = 1;
    public static final int COLUMN_LAT_MIN = 2;
    public static final int COLUMN_LAT_SEC = 3;
    public static final int COLUMN_LAT_HEMISPH = 4;
    public static final int COLUMN_LON_DEG = 5;
    public static final int COLUMN_LON_MIN = 6;
    public static final int COLUMN_LON_SEC = 7;
    public static final int COLUMN_LON_HEMISPH = 8;
    private static final Class[] columnTypes = new Class[]{String.class, Integer.class, Integer.class, Double.class, String.class, Integer.class, Integer.class, Double.class, String.class};
    private final String[] columnNames = new String[]{Messages.getInstance().get("table_name"), Messages.getInstance().get("table_lat_deg"), Messages.getInstance().get("table_lat_min"), Messages.getInstance().get("table_lat_sec"), "", Messages.getInstance().get("table_lon_deg"), Messages.getInstance().get("table_lon_min"), Messages.getInstance().get("table_lon_sec"), ""};

    public Class getColumnClass(int columnIndex) {
        return columnTypes[columnIndex];
    }

    public VfrPointsTableModel() {
        super((Object[][])new Object[0][], new String[0]);
        this.setColumnIdentifiers(this.columnNames);
    }

    public void addPoint(VfrPointDTO p) {
        GpsPlace point = p.getGpsPlace();
        Object[] row = new Object[]{p.getName(), point.getLat().getDeg(), point.getLat().getMin(), point.getLat().getSec(), point.getLatHemisphere(), point.getLon().getDeg(), point.getLon().getMin(), point.getLon().getSec(), point.getLonHemisphere()};
        this.addRow(row);
    }

    public VfrPointDTO getPointAtRow(int row) {
        if (this.rowHasCompleteData(row)) {
            int latDeg = Integer.valueOf(this.getValueAt(row, 1).toString());
            int latMin = Integer.valueOf(this.getValueAt(row, 2).toString());
            double latSec = Double.valueOf(this.getValueAt(row, 3).toString());
            int lonDeg = Integer.valueOf(this.getValueAt(row, 5).toString());
            int lonMin = Integer.valueOf(this.getValueAt(row, 6).toString());
            double lonSec = Double.valueOf(this.getValueAt(row, 7).toString());
            GpsPlace point = new GpsPlace(new GpsCoord(latDeg, latMin, latSec), new GpsCoord(lonDeg, lonMin, lonSec));
            point.setLatHemisphere(this.getValueAt(row, 4).toString());
            point.setLonHemisphere(this.getValueAt(row, 8).toString());
            point.setName(this.getValueAt(row, 0).toString());
            return new VfrPointDTO(point);
        }
        return null;
    }

    public List<VfrPointDTO> getData() {
        ArrayList<VfrPointDTO> data = new ArrayList<VfrPointDTO>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            VfrPointDTO point = this.getPointAtRow(row);
            if (point == null) continue;
            data.add(point);
        }
        return data;
    }

    public boolean allRowsComplete() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (this.rowHasCompleteData(row)) continue;
            return false;
        }
        return true;
    }
}

