/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table.model;

import java.util.ArrayList;
import java.util.List;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.gui.table.model.DataTableModel;
import main.java.guru.vfrflight.weather.core.Station;

public class StationsTableModel
extends DataTableModel {
    private static final long serialVersionUID = 1303028427936428475L;
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_REPORT = 1;
    public List<Station> stations;
    private static final Class[] columnTypes = new Class[]{String.class, String.class};
    private final String[] columnNames = new String[]{Messages.getInstance().get("table_name"), "METAR; TAF"};

    public Class getColumnClass(int columnIndex) {
        return columnTypes[columnIndex];
    }

    public StationsTableModel() {
        super((Object[][])new Object[0][], new String[0]);
        this.setColumnIdentifiers(this.columnNames);
    }

    public void addStation(Station station) {
        String txt = "";
        if (station.getReport().getMetar() != null && station.getReport().getTaf() != null) {
            txt = txt + station.getReport().getMetar() + "\n\n" + station.getReport().getTaf();
        } else if (station.getReport().getMetar() != null) {
            txt = txt + station.getReport().getMetar();
        } else if (station.getReport().getTaf() != null) {
            txt = txt + station.getReport().getTaf();
        }
        Object[] row = new Object[]{station.getIcao(), txt};
        this.getStations().add(station);
        this.addRow(row);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Station getRow(int selectedRow) {
        if (selectedRow < this.getStations().size()) {
            return this.getStations().get(selectedRow);
        }
        return null;
    }

    public List<Station> getStations() {
        if (this.stations == null) {
            this.stations = new ArrayList<Station>();
        }
        return this.stations;
    }

    public void setStations(List<Station> stations) {
        this.stations = stations;
    }
}

