/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table.model;

import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.table.model.DataTableModel;
import main.java.guru.vfrflight.util.GpsUtil;

public class SearchResultTableModel
extends DataTableModel {
    private static final long serialVersionUID = 953340301602162433L;
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_LAT = 1;
    public static final int COLUMN_LON = 2;
    private static final Class[] columnTypes = new Class[]{String.class, String.class, String.class};
    private final String[] columnNames = new String[]{Messages.getInstance().get("table_name"), Messages.getInstance().get("table_lat"), Messages.getInstance().get("table_lon")};

    public Class getColumnClass(int columnIndex) {
        return columnTypes[columnIndex];
    }

    public SearchResultTableModel() {
        super((Object[][])new Object[0][], new String[0]);
        this.setColumnIdentifiers(this.columnNames);
    }

    public void addRow(GpsPlace place) {
        String lat = place.getLat().toString();
        lat = !place.getLat().isMinusValue() ? lat + "N" : lat + "S";
        String lon = place.getLon().toString();
        lon = !place.getLon().isMinusValue() ? lon + "E" : lon + "W";
        this.addRow(new Object[]{place.getDesc(), lat, lon});
    }

    public GpsPlace getRow(int row) {
        String lat = (String)this.getValueAt(row, 1);
        String lon = (String)this.getValueAt(row, 2);
        return new GpsPlace(GpsUtil.parseStringCoord(lat), GpsUtil.parseStringCoord(lon), (String)this.getValueAt(row, 0));
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }
}

