/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table.model;

import java.util.ArrayList;
import java.util.List;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.SceneryConfigEntry;
import main.java.guru.vfrflight.gui.table.model.DataTableModel;
import main.java.guru.vfrflight.util.FormatUtil;

public class SceneryConfigTableModel
extends DataTableModel {
    private static final long serialVersionUID = -892131551888540392L;
    public static final int COLUMN_PATH = 0;
    public static final int COLUMN_SIZE = 1;
    public static final int COLUMN_ACTIVE = 2;
    private List<SceneryConfigEntry> entries;
    private static final Class[] columnTypes = new Class[]{String.class, String.class, Boolean.class};
    private final String[] columnNames = new String[]{Messages.getInstance().get("fsx_import_data_scenery_path"), Messages.getInstance().get("fsx_import_data_scenery_size"), ""};

    public Class getColumnClass(int columnIndex) {
        return columnTypes[columnIndex];
    }

    public SceneryConfigTableModel() {
        super((Object[][])new Object[0][], new String[0]);
        this.setColumnIdentifiers(this.columnNames);
    }

    public void addEntry(SceneryConfigEntry entry) {
        Object[] row = new Object[]{entry.getPath(), FormatUtil.formatFileSizeToGBs(entry.getSize(), 3) + " GB / " + entry.getFileCount(), entry.isActive()};
        this.addRow(row);
    }

    public SceneryConfigEntry getEntryAtRow(int row) {
        SceneryConfigEntry entry = this.entries.get(row);
        entry.setActive((Boolean)this.getValueAt(this.getRowCount() - 1 - row, 2));
        return entry;
    }

    public List<SceneryConfigEntry> getData() {
        ArrayList<SceneryConfigEntry> data = new ArrayList<SceneryConfigEntry>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            SceneryConfigEntry entry = this.getEntryAtRow(row);
            if (!entry.isActive()) continue;
            data.add(entry);
        }
        return data;
    }

    public List<SceneryConfigEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<SceneryConfigEntry> entries) {
        this.entries = entries;
    }
}

