/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table.model;

import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.RouteSegment;
import main.java.guru.vfrflight.gui.table.model.DataTableModel;
import main.java.guru.vfrflight.util.FormatUtil;

public class ResultTableModel
extends DataTableModel {
    private static final long serialVersionUID = -4153607732063378581L;
    public static final int COLUMN_SEGMENT = 0;
    public static final int COLUMN_TR_TRK = 1;
    public static final int COLUMN_MG_TRK = 2;
    public static final int COLUMN_KZ = 3;
    public static final int COLUMN_KM = 4;
    public static final int COLUMN_DISTANCE = 5;
    public static final int COLUMN_W = 6;
    public static final int COLUMN_T = 7;
    public static final int COLUMN_ETA = 8;
    private String[] toolTips = new String[]{Messages.getInstance().get("table_segment_tooltip"), Messages.getInstance().get("table_nkdg_tooltip"), Messages.getInstance().get("table_nkdm_tooltip"), Messages.getInstance().get("table_kz_tooltip"), Messages.getInstance().get("table_km_tooltip"), Messages.getInstance().get("table_distance_tooltip"), Messages.getInstance().get("table_speed_tooltip"), Messages.getInstance().get("table_duration_tooltip"), Messages.getInstance().get("table_eta_tooltip")};
    private static final Class[] columnTypes = new Class[]{String.class, String.class, Integer.class, Integer.class, Double.class, Integer.class, String.class, String.class};
    private final String[] columnNames = new String[]{Messages.getInstance().get("table_segment"), Messages.getInstance().get("table_nkdg"), Messages.getInstance().get("table_nkdm"), Messages.getInstance().get("table_kz"), Messages.getInstance().get("table_km"), Messages.getInstance().get("table_distance", SettingsBean.getInstance().getParamUnitsDistance()), Messages.getInstance().get("table_speed", SettingsBean.getInstance().getParamUnitsSpeed()), Messages.getInstance().get("table_duration"), Messages.getInstance().get("table_eta")};

    public Class getColumnClass(int columnIndex) {
        return columnTypes[columnIndex];
    }

    public ResultTableModel() {
        super((Object[][])new Object[0][], new String[0]);
        this.setColumnIdentifiers(this.columnNames);
    }

    public void addSegment(RouteSegment segment) {
        this.addRow(new Object[]{segment.getSegmentName(), FormatUtil.formattedCourse(segment.getCourse(), false), FormatUtil.formattedCourse(segment.getMagneticCourse(), false), (int)Math.round(segment.getKz()), FormatUtil.formattedCourse(segment.getKm(), false), (double)Math.round(segment.getDistance() * 10.0) / 10.0, (int)Math.round(segment.getW()), FormatUtil.formatTimeLandmark(segment.getT()), FormatUtil.formatTime(segment.getEta())});
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public String[] getToolTips() {
        return this.toolTips;
    }

    public void setToolTips(String[] toolTips) {
        this.toolTips = toolTips;
    }
}

