/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table.model;

import java.util.ArrayList;
import java.util.List;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.gui.table.waypoints.WaypointsTableModel;
import main.java.guru.vfrflight.util.StringUtil;

public class PointsValTableModel
extends WaypointsTableModel {
    private static final long serialVersionUID = -3613315162022953452L;
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_LAT = 1;
    public static final int COLUMN_LAT_HEMISPH = 2;
    public static final int COLUMN_LON = 3;
    public static final int COLUMN_LON_HEMISPH = 4;
    public static final int COLUMN_ALT = 5;
    private static final Class[] columnTypes = new Class[]{String.class, Double.class, String.class, Double.class, String.class, Double.class};
    private final String[] columnNames = new String[]{Messages.getInstance().get("table_name"), Messages.getInstance().get("table_lat"), "", Messages.getInstance().get("table_lon"), "", Messages.getInstance().get("table_alt", SettingsBean.getInstance().getParamUnitsAltitude())};

    public Class getColumnClass(int columnIndex) {
        return columnTypes[columnIndex];
    }

    public PointsValTableModel() {
        super((Object[][])new Object[0][], new String[0]);
        this.setColumnIdentifiers(this.columnNames);
    }

    @Override
    public void addPoint(RoutePlace point) {
        this.addPoint(point, null);
    }

    @Override
    public void addPoint(RoutePlace point, Integer index) {
        Object[] row = new Object[]{point.getName(), Math.abs(point.getLat().getValue()), point.getLatHemisphere(), Math.abs(point.getLon().getValue()), point.getLonHemisphere(), point.getAlt()};
        if (index == null) {
            this.addRow(row);
        } else {
            this.insertRow((int)index, row);
        }
    }

    public RoutePlace getPointAtRow(int row) {
        if (this.rowHasCompleteData(row)) {
            double lat = Double.valueOf(this.getValueAt(row, 1).toString());
            double lon = Double.valueOf(this.getValueAt(row, 3).toString());
            String name = this.getValueAt(row, 0).toString();
            Double alt = null;
            if (!StringUtil.isEmpty(this.getValueAt(row, 5).toString())) {
                alt = (double)Double.valueOf(this.getValueAt(row, 5).toString());
            }
            RoutePlace point = new RoutePlace(new GpsCoord(lat), new GpsCoord(lon), name, alt);
            point.setLatHemisphere(this.getValueAt(row, 2).toString());
            point.setLonHemisphere(this.getValueAt(row, 4).toString());
            point.setType("PT");
            return point;
        }
        return null;
    }

    @Override
    public List<RoutePlace> getData() {
        ArrayList<RoutePlace> data = new ArrayList<RoutePlace>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            RoutePlace point = this.getPointAtRow(row);
            if (point == null) continue;
            data.add(point);
        }
        return data;
    }
}

