/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table.model;

import java.util.ArrayList;
import java.util.List;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.gui.table.waypoints.WaypointsTableModel;
import main.java.guru.vfrflight.util.StringUtil;

public class PointsTableModel
extends WaypointsTableModel {
    private static final long serialVersionUID = -4153607732063378581L;
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_LAT_DEG = 1;
    public static final int COLUMN_LAT_MIN = 2;
    public static final int COLUMN_LAT_SEC = 3;
    public static final int COLUMN_LAT_HEMISPH = 4;
    public static final int COLUMN_LON_DEG = 5;
    public static final int COLUMN_LON_MIN = 6;
    public static final int COLUMN_LON_SEC = 7;
    public static final int COLUMN_LON_HEMISPH = 8;
    public static final int COLUMN_ALT = 9;
    private static final Class[] columnTypes = new Class[]{String.class, Integer.class, Integer.class, Double.class, String.class, Integer.class, Integer.class, Double.class, String.class, Double.class};
    private final String[] columnNames = new String[]{Messages.getInstance().get("table_name"), Messages.getInstance().get("table_lat_deg"), Messages.getInstance().get("table_lat_min"), Messages.getInstance().get("table_lat_sec"), "", Messages.getInstance().get("table_lon_deg"), Messages.getInstance().get("table_lon_min"), Messages.getInstance().get("table_lon_sec"), "", Messages.getInstance().get("table_alt", SettingsBean.getInstance().getParamUnitsAltitude())};

    public Class getColumnClass(int columnIndex) {
        return columnTypes[columnIndex];
    }

    public PointsTableModel() {
        super((Object[][])new Object[0][], new String[0]);
        this.setColumnIdentifiers(this.columnNames);
    }

    @Override
    public void addPoint(RoutePlace point) {
        this.addPoint(point, null);
    }

    @Override
    public void addPoint(RoutePlace point, Integer index) {
        Object[] row = new Object[]{point.getName(), point.getLat().getDeg(), point.getLat().getMin(), point.getLat().getSec(), point.getLatHemisphere(), point.getLon().getDeg(), point.getLon().getMin(), point.getLon().getSec(), point.getLonHemisphere(), point.getAlt()};
        if (index == null) {
            this.addRow(row);
        } else {
            this.insertRow((int)index, row);
        }
    }

    public RoutePlace getPointAtRow(int row) {
        if (this.rowHasCompleteData(row)) {
            int latDeg = Integer.valueOf(this.getValueAt(row, 1).toString());
            int latMin = Integer.valueOf(this.getValueAt(row, 2).toString());
            double latSec = Double.valueOf(this.getValueAt(row, 3).toString());
            int lonDeg = Integer.valueOf(this.getValueAt(row, 5).toString());
            int lonMin = Integer.valueOf(this.getValueAt(row, 6).toString());
            double lonSec = Double.valueOf(this.getValueAt(row, 7).toString());
            String name = this.getValueAt(row, 0).toString();
            Double alt = null;
            if (!StringUtil.isEmpty(this.getValueAt(row, 9).toString())) {
                alt = (double)Double.valueOf(this.getValueAt(row, 9).toString());
            }
            RoutePlace point = new RoutePlace(new GpsCoord(latDeg, latMin, latSec), new GpsCoord(lonDeg, lonMin, lonSec), name, alt);
            point.setLatHemisphere(this.getValueAt(row, 4).toString());
            point.setLonHemisphere(this.getValueAt(row, 8).toString());
            point.setType("PT");
            return point;
        }
        return null;
    }

    @Override
    public List<RoutePlace> getData() {
        ArrayList<RoutePlace> data = new ArrayList<RoutePlace>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            RoutePlace point = this.getPointAtRow(row);
            if (point == null) continue;
            data.add(point);
        }
        return data;
    }
}

