/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table.model;

import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.Airport;
import main.java.guru.vfrflight.gui.table.model.DataTableModel;

public class AlternatesSearchResultTableModel
extends DataTableModel {
    private static final long serialVersionUID = -3437213456458223223L;
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_LAT = 1;
    public static final int COLUMN_LON = 2;
    private static final Class[] columnTypes = new Class[]{String.class, String.class, String.class};
    private final String[] columnNames = new String[]{Messages.getInstance().get("table_name"), Messages.getInstance().get("table_lat"), Messages.getInstance().get("table_lon")};

    public Class getColumnClass(int columnIndex) {
        return columnTypes[columnIndex];
    }

    public AlternatesSearchResultTableModel() {
        super((Object[][])new Object[0][], new String[0]);
        this.setColumnIdentifiers(this.columnNames);
    }

    public void addRow(Airport airport) {
        GpsPlace place = airport.getGpsPlace();
        String lat = place.getLat().toString();
        lat = !place.getLat().isMinusValue() ? lat + "N" : lat + "S";
        String lon = place.getLon().toString();
        lon = !place.getLon().isMinusValue() ? lon + "E" : lon + "W";
        this.addRow(new Object[]{airport.getIdentAndName(), lat, lon});
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }
}

