/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table.model;

import java.util.List;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.AlternateAirport;
import main.java.guru.vfrflight.core.DesiredVector;
import main.java.guru.vfrflight.core.Route;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.table.model.DataTableModel;
import main.java.guru.vfrflight.util.UnitUtil;
import main.java.guru.vfrflight.util.VfrUtil;

public class AlternatesResultTableModel
extends DataTableModel {
    private static final long serialVersionUID = 2591241220729900861L;
    private static Class[] columnTypes;
    private static String[] columnNames;

    public Class getColumnClass(int columnIndex) {
        return columnTypes[columnIndex];
    }

    public AlternatesResultTableModel(Route route) {
        List<AlternateAirport> airportsList = route.getAlternateAirports();
        columnTypes = new Class[airportsList.size() + 1];
        columnNames = new String[airportsList.size() + 1];
        AlternatesResultTableModel.columnTypes[0] = String.class;
        AlternatesResultTableModel.columnNames[0] = Messages.getInstance().get("table_point");
        this.addColumn(columnNames[0]);
        int q = 1;
        for (AlternateAirport a : airportsList) {
            AlternatesResultTableModel.columnTypes[q] = String.class;
            AlternatesResultTableModel.columnNames[q] = a.getIdent();
            this.addColumn(columnNames[q]);
            ++q;
        }
        double windDirection = FlightPlanBean.getInstance().getRoute().getWindDirection();
        double windSpeedKt = FlightPlanBean.getInstance().getRoute().getWindSpeed();
        if (!"kt".equals(SettingsBean.getInstance().getParamUnitsWindSpeed())) {
            windSpeedKt = UnitUtil.recalculateWindSpeed(windSpeedKt, SettingsBean.getInstance().getParamUnitsWindSpeed(), "kt", false);
        }
        double cruiseSpeedKt = FlightPlanBean.getInstance().getRoute().getCruiseSpeed();
        if (!"kt".equals(SettingsBean.getInstance().getParamUnitsSpeed())) {
            cruiseSpeedKt = UnitUtil.recalculateSpeed(cruiseSpeedKt, SettingsBean.getInstance().getParamUnitsSpeed(), "kt", false);
        }
        for (q = 0; q < route.getPoints().size(); ++q) {
            GpsPlace point = route.getPoints().get(q);
            Object[] row = new Object[airportsList.size() + 1];
            row[0] = point.getName();
            for (int i = 0; i < airportsList.size(); ++i) {
                GpsPlace airport = airportsList.get(i).getGpsPlace();
                DesiredVector v = VfrUtil.getDesiredVector(point, airport, cruiseSpeedKt, windSpeedKt, windDirection);
                row[i + 1] = v != null ? v.getInfo() : "--";
            }
            this.addRow(row);
        }
    }

    public AlternatesResultTableModel() {
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }
}

