/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table.model;

import java.util.ArrayList;
import java.util.List;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.bean.SettingsBean;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.map.shape.MapShapeVertex;
import main.java.guru.vfrflight.gui.table.model.DataTableModel;
import main.java.guru.vfrflight.util.StringUtil;

public class AirspaceAreaVertexTableModel
extends DataTableModel {
    private static final long serialVersionUID = 1116329110497806822L;
    public static final int COLUMN_INDEX = 0;
    public static final int COLUMN_LAT_DEG = 1;
    public static final int COLUMN_LAT_MIN = 2;
    public static final int COLUMN_LAT_SEC = 3;
    public static final int COLUMN_LAT_HEMISPH = 4;
    public static final int COLUMN_LON_DEG = 5;
    public static final int COLUMN_LON_MIN = 6;
    public static final int COLUMN_LON_SEC = 7;
    public static final int COLUMN_LON_HEMISPH = 8;
    public static final int COLUMN_TYPE = 9;
    public static final int COLUMN_RADIUS = 10;
    public static final int COLUMN_CLOCKWISE = 11;
    private static final Class[] columnTypes = new Class[]{Integer.class, Integer.class, Integer.class, Double.class, String.class, Integer.class, Integer.class, Double.class, String.class, String.class, Double.class, Boolean.class};
    private final String[] columnNames = new String[]{Messages.getInstance().get("table_index"), Messages.getInstance().get("table_lat_deg"), Messages.getInstance().get("table_lat_min"), Messages.getInstance().get("table_lat_sec"), "", Messages.getInstance().get("table_lon_deg"), Messages.getInstance().get("table_lon_min"), Messages.getInstance().get("table_lon_sec"), "", Messages.getInstance().get("table_type"), Messages.getInstance().get("table_radius", SettingsBean.getInstance().getParamUnitsDistance()), Messages.getInstance().get("table_clockwise")};

    public Class getColumnClass(int columnIndex) {
        return columnTypes[columnIndex];
    }

    public AirspaceAreaVertexTableModel() {
        super((Object[][])new Object[0][], new String[0]);
        this.setColumnIdentifiers(this.columnNames);
    }

    public void addVertex(int index, MapShapeVertex vertex) {
        GpsPlace v = vertex.getGpsPlace();
        Object[] row = new Object[]{index, v.getLat().getDeg(), v.getLat().getMin(), v.getLat().getSec(), v.getLat().isMinusValue() ? "S" : "N", v.getLon().getDeg(), v.getLon().getMin(), v.getLon().getSec(), v.getLon().isMinusValue() ? "W" : "E", vertex.isVertex() ? Messages.getInstance().get("table_vertex_type") : Messages.getInstance().get("table_arc_type"), vertex.isVertex() ? null : vertex.getRadius(), vertex.isVertex() ? null : Boolean.valueOf(vertex.isClockwise())};
        this.addRow(row);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column == 0) {
            return false;
        }
        if (column > 0 && column <= 9) {
            return true;
        }
        return !Messages.getInstance().get("table_vertex_type").equals(this.getValueAt(row, 9).toString());
    }

    @Override
    protected boolean rowHasCompleteData(int row) {
        boolean vertex = this.isVertex(row);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (i >= 10 && vertex || this.getValueAt(row, i) != null && (!(this.getValueAt(row, i) instanceof String) || !StringUtil.isEmpty((String)this.getValueAt(row, i)))) continue;
            return false;
        }
        return true;
    }

    public MapShapeVertex getPointAtRow(int row) {
        if (this.rowHasCompleteData(row)) {
            int latDeg = Integer.valueOf(this.getValueAt(row, 1).toString());
            int latMin = Integer.valueOf(this.getValueAt(row, 2).toString());
            double latSec = Double.valueOf(this.getValueAt(row, 3).toString());
            int lonDeg = Integer.valueOf(this.getValueAt(row, 5).toString());
            int lonMin = Integer.valueOf(this.getValueAt(row, 6).toString());
            double lonSec = Double.valueOf(this.getValueAt(row, 7).toString());
            GpsPlace point = new GpsPlace(new GpsCoord(latDeg, latMin, latSec), new GpsCoord(lonDeg, lonMin, lonSec));
            point.setLatHemisphere(this.getValueAt(row, 4).toString());
            point.setLonHemisphere(this.getValueAt(row, 8).toString());
            MapShapeVertex vertex = new MapShapeVertex(point);
            if (!this.isVertex(row).booleanValue()) {
                double radius = Double.valueOf(this.getValueAt(row, 10).toString());
                boolean clockwise = (Boolean)this.getValueAt(row, 11);
                vertex.setRadius(radius);
                vertex.setClockwise(clockwise);
            }
            return vertex;
        }
        return null;
    }

    public Boolean isVertex(int row) {
        if (this.getValueAt(row, 9) != null) {
            String value = (String)this.getValueAt(row, 9);
            if (Messages.getInstance().get("table_vertex_type").equals(value)) {
                return true;
            }
            return false;
        }
        return null;
    }

    public List<MapShapeVertex> getData() {
        ArrayList<MapShapeVertex> data = new ArrayList<MapShapeVertex>();
        for (int row = 0; row < this.getRowCount(); ++row) {
            MapShapeVertex point = this.getPointAtRow(row);
            if (point == null) continue;
            data.add(point);
        }
        return data;
    }
}

