/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table.model;

import java.util.ArrayList;
import java.util.List;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.core.table.RunwayRow;
import main.java.guru.vfrflight.gui.table.model.DataTableModel;

public class AirportInfoTableModel
extends DataTableModel {
    private static final long serialVersionUID = 6662449331369710772L;
    public static final int COLUMN_RUNWAY = 0;
    public static final int COLUMN_HEADING = 1;
    public static final int COLUMN_LENGTH = 2;
    public static final int COLUMN_WIDTH = 3;
    public static final int COLUMN_TYPE = 4;
    public static final int COLUMN_ILS = 5;
    public static final int COLUMN_ILS_GS = 6;
    public static final int COLUMN_ILS_DME = 7;
    private List<RunwayRow> rows;
    private static final Class[] columnTypes = new Class[]{String.class, Integer.class, Integer.class, Integer.class, String.class, String.class, Boolean.class, Boolean.class};
    private final String[] columnNames = new String[]{Messages.getInstance().get("table_runway"), Messages.getInstance().get("table_heading"), Messages.getInstance().get("table_length"), Messages.getInstance().get("table_width"), Messages.getInstance().get("table_type"), Messages.getInstance().get("table_ils"), Messages.getInstance().get("table_ils_gs"), Messages.getInstance().get("table_ils_dme")};

    public Class getColumnClass(int columnIndex) {
        return columnTypes[columnIndex];
    }

    public AirportInfoTableModel() {
        super((Object[][])new Object[0][], new String[0]);
        this.setColumnIdentifiers(this.columnNames);
    }

    public void addRow(RunwayRow row) {
        this.getRows().add(row);
        this.addRow(new Object[]{row.getName(), row.getHeading(), row.getLength(), row.getWidth(), row.getType(), row.getIls(), row.getGs(), row.getDme()});
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public List<RunwayRow> getRows() {
        if (this.rows == null) {
            this.rows = new ArrayList<RunwayRow>();
        }
        return this.rows;
    }

    public void setRows(List<RunwayRow> rows) {
        this.rows = rows;
    }
}

