/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import main.java.guru.resources.Messages;
import main.java.guru.vfrflight.gui.flightplan.WeightAndBalanceDialog;
import main.java.guru.vfrflight.gui.swing.WnBQuantityUnitComboBoxEditor;
import main.java.guru.vfrflight.gui.table.StrippedDataTable;
import main.java.guru.vfrflight.gui.table.model.DataTableModel;
import main.java.guru.vfrflight.gui.table.model.WeightAndBalanceTableModel;
import main.java.guru.vfrflight.gui.table.model.row.WnBRow;
import main.java.guru.vfrflight.util.UnitUtil;

public class WeightAndBalanceTable
extends StrippedDataTable
implements TableModelListener {
    private static final long serialVersionUID = 6851022935930900321L;
    private boolean suppressValueChanged = false;
    private List<WnBRow> previousRows;
    private WeightAndBalanceDialog dialog;
    private String cogUnit;
    private String torqueUnit;

    public WeightAndBalanceTable(DataTableModel tableModel) {
        super(tableModel);
    }

    public WeightAndBalanceTable(WeightAndBalanceDialog dialog, String cogUnit, String torqueUnit) {
        super(new WeightAndBalanceTableModel());
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        this.getTable().getColumnModel().getColumn(0).setPreferredWidth(180);
        this.getTable().getColumnModel().getColumn(1).setCellRenderer(renderer);
        this.getTable().getColumnModel().getColumn(3).setCellRenderer(renderer);
        this.getTable().getColumnModel().getColumn(1).setPreferredWidth(50);
        this.getTable().getColumnModel().getColumn(2).setPreferredWidth(40);
        this.getTable().getColumnModel().getColumn(2).setCellRenderer(renderer);
        this.getTable().getColumnModel().getColumn(2).setCellEditor(new WnBQuantityUnitComboBoxEditor());
        this.getTable().getColumnModel().getColumn(2).setResizable(false);
        this.getTable().getColumnModel().getColumn(3).setPreferredWidth(70);
        this.getTable().getColumnModel().getColumn(4).setPreferredWidth(110);
        this.getTable().getColumnModel().getColumn(4).setCellRenderer(renderer);
        this.getModel().addTableModelListener(this);
        this.dialog = dialog;
        this.cogUnit = cogUnit;
        this.torqueUnit = torqueUnit;
    }

    public void setData(List<WnBRow> rows) {
        this.suppressValueChanged = true;
        this.clearData();
        for (WnBRow row : rows) {
            if (row.getQuantity() != null && row.getQuantityUnit() != null && row.getArm() != null) {
                row.setTorque(UnitUtil.calculateTorque(row.getQuantity(), row.getQuantityUnit(), row.getArm(), this.getCogUnit(), this.getTorqueUnit(), true));
            }
            this.addWnbRow(row);
        }
        this.setPreviousRows(rows);
        this.suppressValueChanged = false;
    }

    public Double getMass(String unit) {
        List<WnBRow> rows = this.getData();
        if (rows.size() > 0) {
            double mass = 0.0;
            for (WnBRow row : rows) {
                if (row.getQuantity() == null || row.getQuantityUnit() == null || row.getArm() == null) continue;
                double val = row.getQuantity();
                if (!unit.equals(row.getQuantityUnit())) {
                    val = UnitUtil.recalculateFuel(val, row.getQuantityUnit(), unit, false);
                }
                mass += val;
            }
            return (double)Math.round(mass * 10.0) / 10.0;
        }
        return null;
    }

    public Double getCoG() {
        String massUnit = null;
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (WnBRow row : this.getData()) {
            if (row.getQuantity() == null || row.getArm() == null || row.getQuantityUnit() == null) continue;
            if (!counts.containsKey(row.getQuantityUnit())) {
                counts.put(row.getQuantityUnit(), 1);
                continue;
            }
            int cnt = (Integer)counts.get(row.getQuantityUnit());
            counts.put(row.getQuantityUnit(), ++cnt);
        }
        if (counts.size() > 0) {
            int max = 0;
            for (Map.Entry entry : counts.entrySet()) {
                if (massUnit != null && (Integer)entry.getValue() < max) continue;
                massUnit = (String)entry.getKey();
                max = (Integer)entry.getValue();
            }
        } else {
            massUnit = "kg";
        }
        double mass = 0.0;
        Double cog = null;
        cog = 0.0;
        for (WnBRow row : this.getData()) {
            if (row.getQuantity() == null || row.getQuantityUnit() == null || row.getArm() == null) continue;
            double m = row.getQuantity();
            if (!massUnit.equals(row.getQuantityUnit())) {
                m = UnitUtil.recalculateFuel(m, row.getQuantityUnit(), massUnit, false);
            }
            cog = cog + m * row.getArm();
            mass += m;
        }
        return mass > 0.0 ? Double.valueOf((double)Math.round(cog / mass * 10.0) / 10.0) : null;
    }

    @Override
    public WeightAndBalanceTableModel getModel() {
        return (WeightAndBalanceTableModel)this.table.getModel();
    }

    public WnBRow getWnbRowAt(int row) {
        return this.getModel().getWnbRowAt(row);
    }

    public List<WnBRow> getPreviousRows() {
        if (this.previousRows == null) {
            return new ArrayList<WnBRow>();
        }
        return this.previousRows;
    }

    public List<WnBRow> getData() {
        return this.getModel().getData();
    }

    public void addWnbRow(WnBRow row) {
        this.suppressValueChanged = true;
        this.getModel().addWnbRow(row);
        this.suppressValueChanged = false;
    }

    public void recalculateCoG(String unit) {
        if (!unit.equals(this.getCogUnit())) {
            this.suppressValueChanged = true;
            List<WnBRow> rows = this.getData();
            for (int i = 0; i < rows.size(); ++i) {
                WnBRow row = rows.get(i);
                Double cog = row.getArm();
                if (cog == null) continue;
                cog = UnitUtil.recalculateDistance(cog, this.getCogUnit(), unit, true);
                this.getModel().setValueAt(cog, i, 3);
            }
            this.setCogUnit(unit);
            this.suppressValueChanged = false;
        }
    }

    public void recalculateTorque(String torque) {
        if (!torque.equals(this.getTorqueUnit())) {
            this.suppressValueChanged = true;
            List<WnBRow> rows = this.getData();
            for (int i = 0; i < rows.size(); ++i) {
                WnBRow row = rows.get(i);
                Double t = row.getTorque();
                if (t == null) continue;
                t = UnitUtil.recalculateTorque(t, this.getTorqueUnit(), torque, true);
                this.getModel().setValueAt(t, i, 4);
            }
            this.setTorqueUnit(torque);
            this.suppressValueChanged = false;
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this.suppressValueChanged && this.getPreviousRows().size() == 0 || e.getFirstRow() >= this.getPreviousRows().size()) {
            this.setPreviousRows(this.getData());
        } else if (!this.suppressValueChanged) {
            WnBRow oldRow = this.getPreviousRows().get(e.getFirstRow());
            WnBRow newRow = this.getWnbRowAt(e.getFirstRow());
            if (oldRow != null && newRow != null) {
                this.suppressValueChanged = true;
                if (2 == e.getColumn() && oldRow.getQuantity() != null && newRow.getQuantity() != null && !newRow.getQuantityUnit().equals(oldRow.getQuantityUnit())) {
                    newRow.setQuantity(UnitUtil.recalculateFuel(oldRow.getQuantity(), oldRow.getQuantityUnit(), newRow.getQuantityUnit(), false));
                    this.getModel().setValueAt((double)Math.round(newRow.getQuantity() * 10.0) / 10.0, e.getFirstRow(), 1);
                }
                if (newRow.getQuantity() != null && newRow.getArm() != null) {
                    this.getModel().setValueAt(UnitUtil.calculateTorque(newRow.getQuantity(), newRow.getQuantityUnit(), newRow.getArm(), this.getCogUnit(), this.getTorqueUnit(), true), e.getFirstRow(), 4);
                } else {
                    this.getModel().setValueAt(null, e.getFirstRow(), 4);
                }
                this.suppressValueChanged = false;
                this.dialog.recalculateInfoLabel();
                this.setPreviousRows(this.getData());
            }
        }
    }

    public void setPreviousRows(List<WnBRow> previousRows) {
        this.previousRows = previousRows;
    }

    @Override
    public void removeRow(int row) {
        this.suppressValueChanged = true;
        this.getModel().removeRow(row);
        this.suppressValueChanged = false;
    }

    public String getCogUnit() {
        return this.cogUnit;
    }

    public void setCogUnit(String cogUnit) {
        this.cogUnit = cogUnit;
        this.updateHeader();
    }

    public String getTorqueUnit() {
        return this.torqueUnit;
    }

    public void setTorqueUnit(String torqueUnit) {
        this.torqueUnit = torqueUnit;
        this.updateHeader();
    }

    public void updateHeader() {
        this.getTable().getTableHeader().getColumnModel().getColumn(3).setHeaderValue(Messages.getInstance().get("wnb_table_arm") + " [" + this.cogUnit + "]");
        this.getTable().getTableHeader().getColumnModel().getColumn(4).setHeaderValue(Messages.getInstance().get("wnb_table_torque") + " [" + this.torqueUnit + "]");
        this.getTable().getTableHeader().repaint();
    }

    @Override
    public void clearData() {
        this.suppressValueChanged = true;
        super.clearData();
        this.suppressValueChanged = false;
    }
}

