/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table;

import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import main.java.guru.vfrflight.core.dto.VfrPointDTO;
import main.java.guru.vfrflight.gui.swing.LatitudeComboBoxEditor;
import main.java.guru.vfrflight.gui.swing.LongitudeComboBoxEditor;
import main.java.guru.vfrflight.gui.table.model.VfrPointsTableModel;
import main.java.guru.vfrflight.gui.table.vfr.VfrDataTable;

public class VfrPointsDataTable
extends VfrDataTable
implements ListSelectionListener,
TableModelListener {
    private static final long serialVersionUID = 4542418712910153614L;
    protected boolean suppressValueChanged = false;

    public VfrPointsDataTable(List<VfrPointDTO> points) {
        super(new VfrPointsTableModel());
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        this.getTable().getColumnModel().getColumn(0).setPreferredWidth(200);
        this.getTable().getColumnModel().getColumn(4).setPreferredWidth(25);
        this.getTable().getColumnModel().getColumn(4).setCellRenderer(renderer);
        this.getTable().getColumnModel().getColumn(4).setCellEditor(new LatitudeComboBoxEditor());
        this.getTable().getColumnModel().getColumn(4).setResizable(false);
        this.getTable().getColumnModel().getColumn(8).setPreferredWidth(25);
        this.getTable().getColumnModel().getColumn(8).setCellRenderer(renderer);
        this.getTable().getColumnModel().getColumn(8).setCellEditor(new LongitudeComboBoxEditor());
        this.getTable().getColumnModel().getColumn(8).setResizable(false);
        this.getTable().getSelectionModel().addListSelectionListener(this);
        this.getModel().addTableModelListener(this);
        if (points != null) {
            this.setData(points);
        }
    }

    @Override
    public void setData(List<VfrPointDTO> points) {
        this.suppressValueChanged = true;
        this.clearData();
        for (VfrPointDTO point : points) {
            this.addPoint(point);
        }
        this.suppressValueChanged = false;
    }

    @Override
    public VfrPointsTableModel getModel() {
        return (VfrPointsTableModel)this.table.getModel();
    }

    @Override
    public VfrPointDTO getPointAtRow(int row) {
        return this.getModel().getPointAtRow(row);
    }

    @Override
    public List<VfrPointDTO> getData() {
        return this.getModel().getData();
    }

    @Override
    public void addPoint(VfrPointDTO point) {
        this.getModel().addPoint(point);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    @Override
    public void selectRow(int row) {
        this.suppressValueChanged = true;
        super.selectRow(row);
        this.suppressValueChanged = false;
    }

    @Override
    public void tableChanged(TableModelEvent tablemodelevent) {
    }

    @Override
    public boolean allRowsComplete() {
        return this.getModel().allRowsComplete();
    }
}

