/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.guru.vfrflight.gui.table.PointsValDataTable;
import main.java.guru.vfrflight.sql.facade.UserPointFacade;
import main.java.guru.vfrflight.util.DBUtil;

public class UserPointsValDataTable
extends PointsValDataTable {
    private static final long serialVersionUID = -6894295079543950946L;
    private List<UserPoint> points;
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_LAT = 1;
    public static final int COLUMN_LAT_HEMISPH = 2;
    public static final int COLUMN_LON = 3;
    public static final int COLUMN_LON_HEMISPH = 4;

    public UserPointsValDataTable(List<UserPoint> points) {
        super(true);
        this.points = points;
        if (points != null) {
            ArrayList<RoutePlace> result = new ArrayList<RoutePlace>();
            for (int i = 0; i < points.size(); ++i) {
                result.add(points.get(i).getRoutePlace());
            }
            this.setData(result);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tme) {
        if (!this.suppressValueChanged) {
            UserPointFacade userPointFacade = new UserPointFacade(DBUtil.getDataSource());
            userPointFacade.updateUserPoint(this.getUpdatedPoint(tme.getFirstRow(), tme.getColumn()));
        }
    }

    @Override
    public void removeRow(int row) {
        this.suppressValueChanged = true;
        UserPoint userPoint = this.points.get(row);
        UserPointFacade userPointFacade = new UserPointFacade(DBUtil.getDataSource());
        if (userPointFacade.deleteUserPointById(userPoint.getId())) {
            this.points.remove(row);
            this.getModel().removeRow(row);
        }
        this.suppressValueChanged = false;
    }

    public UserPoint getUpdatedPoint(int idx, int colnum) {
        UserPoint userPointChanged = this.points.get(idx);
        RoutePlace pointChanged = this.getPointAtRow(idx);
        if (colnum == 0) {
            userPointChanged.setName(pointChanged.getName());
        } else if (colnum == 1) {
            userPointChanged.setLat(pointChanged.getLat().getValue());
        } else if (colnum == 2) {
            int sign = "N".equals(pointChanged.getLatHemisphere()) ? 1 : -1;
            userPointChanged.setLat((double)sign * Math.abs(pointChanged.getLatVal()));
        } else if (colnum == 3) {
            userPointChanged.setLon(pointChanged.getLon().getValue());
        } else if (colnum == 4) {
            int sign = "E".equals(pointChanged.getLonHemisphere()) ? 1 : -1;
            userPointChanged.setLon((double)sign * Math.abs(pointChanged.getLonVal()));
        }
        return userPointChanged;
    }

    public void addUserPoint(UserPoint point) {
        this.points.add(point);
        super.addPoint(point.getRoutePlace());
    }

    public List<UserPoint> getPoints() {
        return this.points;
    }

    public void setPoints(List<UserPoint> points) {
        this.points = points;
    }
}

