/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table;

import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.DefaultTableCellRenderer;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.sql.entity.UserPoint;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.table.StrippedDataTable;
import main.java.guru.vfrflight.gui.table.model.UserPointsTableModel;
import main.java.guru.vfrflight.util.StringUtil;

public class UserPointsDataTable
extends StrippedDataTable
implements MouseListener,
KeyListener {
    private static final long serialVersionUID = -6894295079543950946L;
    private List<UserPoint> points;

    public UserPointsDataTable(List<UserPoint> points) {
        super(new UserPointsTableModel());
        this.points = points;
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        this.getTable().getColumnModel().getColumn(0).setPreferredWidth(150);
        this.getTable().getColumnModel().getColumn(1).setMaxWidth(50);
        this.getTable().getColumnModel().getColumn(1).setCellRenderer(renderer);
        this.getTable().getColumnModel().getColumn(2).setMaxWidth(50);
        this.getTable().getColumnModel().getColumn(2).setCellRenderer(renderer);
        this.getTable().getColumnModel().getColumn(3).setMaxWidth(50);
        this.getTable().getColumnModel().getColumn(3).setCellRenderer(renderer);
        this.getTable().getColumnModel().getColumn(4).setMaxWidth(25);
        this.getTable().getColumnModel().getColumn(4).setCellRenderer(renderer);
        this.getTable().getColumnModel().getColumn(4).setResizable(false);
        this.getTable().getColumnModel().getColumn(5).setMaxWidth(50);
        this.getTable().getColumnModel().getColumn(5).setCellRenderer(renderer);
        this.getTable().getColumnModel().getColumn(6).setMaxWidth(50);
        this.getTable().getColumnModel().getColumn(6).setCellRenderer(renderer);
        this.getTable().getColumnModel().getColumn(7).setMaxWidth(50);
        this.getTable().getColumnModel().getColumn(7).setCellRenderer(renderer);
        this.getTable().getColumnModel().getColumn(8).setMaxWidth(25);
        this.getTable().getColumnModel().getColumn(8).setCellRenderer(renderer);
        this.getTable().getColumnModel().getColumn(8).setResizable(false);
        this.getTable().getColumnModel().getColumn(9).setPreferredWidth(200);
        this.getTable().addMouseListener(this);
        this.getTable().addKeyListener(this);
        if (points != null) {
            this.setData(points);
        }
    }

    public void setData(List<UserPoint> points) {
        this.clearData();
        for (UserPoint point : points) {
            this.addPoint(point);
        }
    }

    public void addPoint(UserPoint point) {
        this.addPoint(point, null);
    }

    public void addPoint(UserPoint point, Integer index) {
        this.getModel().addPoint(point, index);
    }

    @Override
    public UserPointsTableModel getModel() {
        return (UserPointsTableModel)this.table.getModel();
    }

    public void addUserPoint(UserPoint point) {
        this.points.add(point);
        this.addPoint(point);
    }

    public List<UserPoint> getPoints() {
        return this.points;
    }

    public void setPoints(List<UserPoint> points) {
        this.points = points;
    }

    public UserPoint getSelectedPoint() {
        int selRow = this.getTable().getSelectedRow();
        if (selRow >= 0) {
            return this.points.get(selRow);
        }
        return null;
    }

    public List<UserPoint> getSelectedPoints() {
        ArrayList<UserPoint> points = new ArrayList<UserPoint>();
        int[] idxs = this.getTable().getSelectedRows();
        for (int q = 0; q < idxs.length; ++q) {
            points.add(this.getPoints().get(idxs[q]).clone());
        }
        return points;
    }

    public void sortByName() {
        Collections.sort(this.points, new SortByNameComparator());
        this.setData(new ArrayList<UserPoint>(this.points));
    }

    public void sortByTags() {
        Collections.sort(this.points, new SortByTagsComparator());
        this.setData(new ArrayList<UserPoint>(this.points));
    }

    public void centerOnSelected() {
        int sel = this.getTable().getSelectedRow();
        if (sel >= 0) {
            GpsPlace place = this.points.get(sel).getGpsPlace();
            MapFrame.getInstance().centerOnPoint(place, 8);
            MapFrame.getInstance().setPlaceTempHighlightMode(place);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.centerOnSelected();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.points != null && e.getKeyCode() >= 32 && e.getKeyCode() <= 126) {
            for (int i = 0; i < this.points.size(); ++i) {
                String name = this.points.get(i).getName().toLowerCase();
                if (!name.startsWith(String.valueOf(e.getKeyChar()).toLowerCase())) continue;
                this.getTable().getSelectionModel().setSelectionInterval(i, i);
                this.getTable().scrollRectToVisible(new Rectangle(this.getTable().getCellRect(i, 0, true)));
                break;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private class SortByTagsComparator
    implements Comparator<UserPoint> {
        private SortByTagsComparator() {
        }

        @Override
        public int compare(UserPoint o1, UserPoint o2) {
            return StringUtil.nullToEmpty(o1.getTags()).trim().toUpperCase().compareTo(StringUtil.nullToEmpty(o2.getTags()).trim().toUpperCase());
        }
    }

    private class SortByNameComparator
    implements Comparator<UserPoint> {
        private SortByNameComparator() {
        }

        @Override
        public int compare(UserPoint o1, UserPoint o2) {
            return StringUtil.nullToEmpty(o1.getName()).trim().toUpperCase().compareTo(StringUtil.nullToEmpty(o2.getName()).trim().toUpperCase());
        }
    }
}

