/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class StrippedJTable
extends JTable {
    private static final long serialVersionUID = 2289375102205932652L;
    private static final Color BACKGROUND_COLOR = new Color(230, 240, 255);

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintEmptyRows(g);
    }

    public void paintEmptyRows(Graphics g) {
        Graphics newGraphics = g.create();
        Rectangle rectOfLastRow = this.getCellRect(this.getRowCount() - 1, 0, true);
        int firstNonExistentRowY = rectOfLastRow.y;
        if (this.getVisibleRect().height > firstNonExistentRowY) {
            int rowYToDraw = firstNonExistentRowY - 1 + this.getRowHeight();
            int actualRow = this.getRowCount() - 1;
            while (rowYToDraw < this.getHeight()) {
                if (actualRow % 2 == 0) {
                    newGraphics.setColor(BACKGROUND_COLOR);
                } else {
                    newGraphics.setColor(Color.WHITE);
                }
                newGraphics.fillRect(0, rowYToDraw, this.getWidth(), this.getRowHeight());
                rowYToDraw += this.getRowHeight();
                ++actualRow;
            }
            newGraphics.dispose();
        }
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (!this.isRowSelected(row)) {
            c.setBackground(row % 2 == 0 ? this.getBackground() : BACKGROUND_COLOR);
        }
        c.setEnabled(this.isEnabled());
        return c;
    }
}

