/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table;

import java.awt.Font;
import java.util.List;
import main.java.guru.vfrflight.core.gps.GpsCoord;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.table.DataTable;
import main.java.guru.vfrflight.gui.table.WordWrapCellRenderer;
import main.java.guru.vfrflight.gui.table.model.StationsTableModel;
import main.java.guru.vfrflight.weather.core.Station;

public class StationsDataTable
extends DataTable {
    private static final long serialVersionUID = 5028784581336087119L;

    public StationsDataTable() {
        super(new StationsTableModel());
        this.disableMouseWheel();
        this.getTable().getTableHeader().setFont(new Font("SansSerif", 1, 9));
        this.getTable().setFont(new Font("SansSerif", 0, 10));
        this.getTable().getColumnModel().getColumn(0).setMaxWidth(100);
        this.getTable().getColumnModel().getColumn(1).setCellRenderer(new WordWrapCellRenderer());
    }

    public void setData(List<Station> stations) {
        this.clearData();
        for (Station station : stations) {
            this.addStation(station);
        }
    }

    public void addStation(Station station) {
        StationsTableModel model = (StationsTableModel)this.getModel();
        model.addStation(station);
    }

    public void centerMapOnSelectedStation() {
        int selectedRow = this.getTable().getSelectedRow();
        if (selectedRow >= 0) {
            StationsTableModel model = (StationsTableModel)this.getModel();
            Station station = model.getRow(selectedRow);
            GpsPlace place = new GpsPlace(new GpsCoord(station.getLat()), new GpsCoord(station.getLon()), station.getName());
            MapFrame.getInstance().centerOnPoint(place, false);
            MapFrame.getInstance().updateMap();
        }
    }

    @Override
    public void clearData() {
        super.clearData();
        StationsTableModel model = (StationsTableModel)this.getModel();
        model.setStations(null);
    }
}

