/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.table.DefaultTableCellRenderer;
import main.java.guru.vfrflight.bean.FlightPlanBean;
import main.java.guru.vfrflight.core.gps.GpsPlace;
import main.java.guru.vfrflight.core.gps.RoutePlace;
import main.java.guru.vfrflight.gui.flightplan.MapFrame;
import main.java.guru.vfrflight.gui.table.DataTable;
import main.java.guru.vfrflight.gui.table.model.SearchResultTableModel;

public class SearchResultDataTable
extends DataTable
implements MouseListener {
    private static final long serialVersionUID = -7332548675998632230L;
    private boolean navaidMode = false;
    private final boolean drawPointOnMap;

    public SearchResultDataTable() {
        this(true);
    }

    public SearchResultDataTable(boolean drawPointOnMap) {
        super(new SearchResultTableModel());
        this.getTable().getColumnModel().getColumn(0).setPreferredWidth(250);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        for (int i = 1; i < this.getModel().getColumnCount(); ++i) {
            this.getTable().getColumnModel().getColumn(i).setCellRenderer(renderer);
        }
        this.getTable().addMouseListener(this);
        this.drawPointOnMap = drawPointOnMap;
    }

    public void setData(List<GpsPlace> places) {
        this.clearData();
        for (GpsPlace place : places) {
            this.addRow(place);
        }
    }

    public void addRow(GpsPlace place) {
        SearchResultTableModel model = (SearchResultTableModel)this.getModel();
        model.addRow(place);
    }

    public void centerOnSelected() {
        if (this.getTable().getSelectedRow() >= 0) {
            this.showPointOnMap(this.getTable().getSelectedRow());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.centerOnSelected();
        }
    }

    public void showPointOnMap(int i) {
        SearchResultTableModel model = (SearchResultTableModel)this.getModel();
        RoutePlace phantomPoint = new RoutePlace(model.getRow(i));
        if (this.drawPointOnMap) {
            if (this.navaidMode) {
                FlightPlanBean.getInstance().getRoute().addPhantomVor(phantomPoint);
            } else {
                FlightPlanBean.getInstance().getRoute().addPhantomPoint(phantomPoint);
            }
            MapFrame.getInstance().centerOnPoint(phantomPoint);
        } else {
            MapFrame.getInstance().centerOnPoint((GpsPlace)phantomPoint, 8);
            MapFrame.getInstance().setMarkerPlace(phantomPoint);
        }
        MapFrame.getInstance().setPlaceTempHighlightMode(phantomPoint);
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    public void setNavaidMode(boolean navaidMode) {
        this.navaidMode = navaidMode;
    }
}

