/*
 * Decompiled with CFR 0.152.
 */
package main.java.guru.vfrflight.gui.table;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import main.java.guru.vfrflight.core.SceneryConfigEntry;
import main.java.guru.vfrflight.gui.flightplan.ImportDataStepDialog;
import main.java.guru.vfrflight.gui.table.StrippedDataTable;
import main.java.guru.vfrflight.gui.table.model.SceneryConfigTableModel;

public class SceneryConfigDataTable
extends StrippedDataTable
implements TableModelListener {
    private static final long serialVersionUID = 4437684045056012116L;
    private boolean suppressValueChanged = false;
    private final ImportDataStepDialog dialog;

    public SceneryConfigDataTable(ImportDataStepDialog dialog) {
        super(new SceneryConfigTableModel());
        this.dialog = dialog;
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        this.getTable().getColumnModel().getColumn(2).setMaxWidth(50);
        this.getTable().getColumnModel().getColumn(1).setCellRenderer(renderer);
        this.getTable().getColumnModel().getColumn(1).setMinWidth(120);
        this.getTable().getColumnModel().getColumn(1).setMaxWidth(200);
        this.getModel().addTableModelListener(this);
    }

    public void setData(List<SceneryConfigEntry> entries) {
        this.suppressValueChanged = true;
        this.clearData();
        this.getModel().setEntries(new ArrayList<SceneryConfigEntry>(entries));
        for (int i = entries.size() - 1; i >= 0; --i) {
            SceneryConfigEntry entry = entries.get(i);
            this.addEntry(entry);
        }
        this.suppressValueChanged = false;
    }

    public List<SceneryConfigEntry> getData() {
        return this.getModel().getData();
    }

    @Override
    public SceneryConfigTableModel getModel() {
        return (SceneryConfigTableModel)this.table.getModel();
    }

    public void addEntry(SceneryConfigEntry entry) {
        this.getModel().addEntry(entry);
    }

    public boolean isAllUnchecked() {
        return this.getData().size() == 0;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this.suppressValueChanged && 2 == e.getColumn()) {
            this.dialog.updateSelectionStatus();
        }
    }

    @Override
    public void clearData() {
        this.suppressValueChanged = true;
        super.clearData();
        if (this.getModel().getEntries() != null) {
            this.getModel().setEntries(null);
        }
        this.suppressValueChanged = false;
    }

    public boolean anySelected() {
        if (this.getModel().getEntries() == null) {
            return false;
        }
        for (SceneryConfigEntry entry : this.getModel().getEntries()) {
            if (!entry.isActive()) continue;
            return true;
        }
        return false;
    }

    public void deselectAll() {
        for (SceneryConfigEntry entry : this.getModel().getEntries()) {
            entry.setActive(false);
        }
        this.setData(this.getModel().getEntries());
    }

    public void selectAll() {
        for (SceneryConfigEntry entry : this.getModel().getEntries()) {
            entry.setActive(true);
        }
        this.setData(this.getModel().getEntries());
    }
}

